<?php
use App\Http\Controllers\ActivityLogController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\Admin\ConfigurationController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\AppelController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ExportController;
use App\Http\Controllers\PlainteController;
use App\Http\Controllers\InvestigationController;
use App\Http\Controllers\FinancementController;
use App\Http\Controllers\ParametreController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ResolutionController;
use App\Http\Middleware\SetLocale;
use App\Models\Plainte;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;

//GUEST ROUTES

// Language switcher routes
Route::get('language/{lang}', [LanguageController::class, 'switchLang'])->name('language.switch');
// Route::post('set-locale', [LanguageController::class, 'setLocale'])->name('set.locale');

Route::get('test',function() {
    $plainte = Plainte::join('plaignants', 'plaintes.plaignant_id', '=', 'plaignants.id')
    ->groupBy('plaignants.nom')
    ->select('plaignants.nom', DB::raw('COUNT(plaintes.id) as total'))
    ->get();
    return $plainte;
});
// Apply locale middleware to all routes
Route::middleware(SetLocale::class)->group(function () {
    Route::get('/', function () {
        return view('welcome');
    })->name('home');
    Route::get('formulaire-de-depot-de-plainte',[PlainteController::class, 'formulaire'])->name('plaintes.formulaire');
    Route::get('liste-des-plaintes', [PlainteController::class, 'liste'])->name('plaintes.liste');
    Route::get('formulaire-de-depot-de-demande-de-financement',[FinancementController::class, 'formulaire'])->name('financements.formulaire');
    Route::get('suivi-plainte/{reference}', [PlainteController::class, 'suiviPlainte'])->name('plaintes.suivi-plainte');
    Route::get('suivi-financement/{reference}', [FinancementController::class, 'suiviFinancement'])->name('financements.suivi-financement');
    Route::post('plaintes/store', [PlainteController::class, 'store'])->name('plaintes.store');
});
// Auth middleware group
Route::middleware(['auth'])->group(function () {
    Route::get('/fieadm', [DashboardController::class, 'index'])->name('dashboard');
    
    Route::resource('financements', FinancementController::class);

    // Routes d'exportation
    Route::prefix('exports')->name('exports.')->group(function () {
        // Export des plaintes
        Route::get('/plaintes/excel', [ExportController::class, 'exportPlaintesExcel'])->name('plaintes.excel');
        Route::get('/plaintes/csv', [ExportController::class, 'exportPlaintesCSV'])->name('plaintes.csv');
        Route::get('/plaintes/pdf', [ExportController::class, 'exportPlaintesPDF'])->name('plaintes.pdf');
        
        // Export des demandes de financement
        Route::get('/financements/excel', [ExportController::class, 'exportFinancementsExcel'])->name('financements.excel');
        Route::get('/financements/csv', [ExportController::class, 'exportFinancementsCSV'])->name('financements.csv');
        Route::get('/financements/pdf', [ExportController::class, 'exportFinancementsPDF'])->name('financements.pdf');
    });
     // Gestion des utilisateurs
    Route::get('admin/dashboard', function () {
        return view('dashboard.index');
    })->name('admin.dashboard');
    Route::resource('users', UserController::class);
    Route::resource('roles', RoleController::class);
    // Gestion des paramètres
    Route::resource('parametres', ParametreController::class);
    Route::resource('configurations', ConfigurationController::class);
    Route::patch('financements/{financement}/status', [FinancementController::class, 'updateStatus'])
     ->name('financements.update-status');
    Route::get('download-file/{media}', [FinancementController::class, 'downloadFile'])
     ->name('media.download');
    // Gestion des plaintes
    Route::resource('plaintes', PlainteController::class);
    Route::patch('plaintes/{plainte}/status', [PlainteController::class, 'updateStatus'])
         ->name('plaintes.update-status');
    
    Route::post('plaintes/{plainte}/proposer-resolution', [PlainteController::class, 'proposerResolution'])->name('plaintes.proposer-resolution');
    // Enquêtes
    Route::get('plaintes/{plainte}/investigations/create', [InvestigationController::class, 'create'])
         ->name('investigations.create');
    Route::post('plaintes/{plainte}/investigations', [InvestigationController::class, 'store'])
         ->name('investigations.store');
    
    // Appels
    Route::get('plaintes/{plainte}/appeals/create', [AppelController::class, 'create'])
         ->name('appeals.create');
    Route::post('plaintes/{plainte}/appeals', [AppelController::class, 'store'])
         ->name('appeals.store');
    Route::patch('appeals/{appeal}/process', [AppelController::class, 'processAppeal'])
         ->name('appeals.process');
    
    // Rapports et statistiques
    // Route::get('dashboard', [ReportController::class, 'dashboard'])->name('dashboard');
    Route::get('reports/monthly', [ReportController::class, 'monthlyReport'])->name('reports.monthly');
    
    // API pour statistiques en temps réel
    Route::get('api/stats/real-time', function() {
        return response()->json([
            'total_today' => Plainte::whereDate('date_reception', today())->count(),
            'pending' => Plainte::whereIn('statut', ['recu', 'en_examen', 'en_enquete'])->count(),
            'overdue' => Plainte::get()->filter->isDelaiDepasse()->count(),
        ]);
    });


    // Activity Logs
    Route::get('activity-logs', [ActivityLogController::class, 'index'])->name('activity-logs.index');
    Route::get('activity-logs/{id}', [ActivityLogController::class, 'show'])->name('activity-logs.show');     

});

// Resolution routes
Route::middleware('auth')->group(function () {
    Route::resource('plaintes.resolutions', ResolutionController::class)
        ->except(['index', 'show'])
        ->shallow();
    
    
});
// Public route for accepting/rejecting resolutions
Route::post('resolutions/{resolution}/accept', [ResolutionController::class, 'accept'])
->name('resolutions.accept');
Route::post('resolutions/{resolution}/reject', [ResolutionController::class, 'reject'])
->name('resolutions.reject');

// Public route for viewing resolution (with token)
Route::get('resolutions/{resolution}', [ResolutionController::class, 'show'])
    ->name('resolutions.show')
    ->middleware('signed');
require __DIR__.'/auth.php';