@extends('layouts.front')
@push('styles')
    <style>
        /* Success Modal */
        .success-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.8);
            z-index: 9999;
            align-items: center;
            justify-content: center;
        }

        .success-modal.show {
            display: flex;
        }

        .success-content {
            background: white;
            padding: 3rem;
            border-radius: 20px;
            text-align: center;
            max-width: 500px;
            animation: slideUp 0.4s ease;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(50px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .success-icon {
            font-size: 5rem;
            color: #2e8b57;
            margin-bottom: 1rem;
        }

        .success-content h2 {
            color: #2e8b57;
            margin-bottom: 1rem;
        }

        .reference-number {
            background: #f8f9fa;
            padding: 1rem;
            border-radius: 10px;
            margin: 1rem 0;
            font-weight: bold;
            color: #2e8b57;
        }
    </style>
@endpush
@section('hero')
<section class="hero" id="accueil">
  <div class="floating-elements"></div>
  <div class="container">
      <h1>@lang('messages.complaints_suggestions')</h1>
      <p>@lang('messages.welcome_description')</p>
      <div class="cta-buttons">
          <a href="{{ route('plaintes.formulaire') }}" class="cta-btn btn-primary">
              <i class="fas fa-paper-plane"></i>
              @lang('messages.file_complaint')
          </a>
          <a href="#processus" class="cta-btn btn-secondary">
              <i class="fas fa-info-circle"></i>
              @lang('messages.how_it_works')
          </a>
      </div>

  </div>
  <div class="scroll-indicator">
      <i class="fas fa-chevron-down"></i>
  </div>

</section>
@endsection
@section('content')
        <section class="content-section" id="processus">
            <div class="container">
                <div class="section-header">
                    <h2>@lang('messages.our_process')</h2>
                    <p>@lang('messages.process_description')</p>
                </div>

                <div class="timeline">
                    <div class="timeline-item">
                        <div class="timeline-content">
                            <h3><i class="fas fa-clipboard"></i> @lang('messages.step1_title')</h3>
                            <p>@lang('messages.step1_desc')</p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-content">
                            <h3><i class="fas fa-sort-amount-up"></i> @lang('messages.step2_title')</h3>
                            <p>@lang('messages.step2_desc')</p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-content">
                            <h3><i class="fas fa-check-circle"></i> @lang('messages.step3_title')</h3>
                            <p>@lang('messages.step3_desc')</p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-content">
                            <h3><i class="fas fa-comments"></i> @lang('messages.step4_title')</h3>
                            <p>@lang('messages.step4_desc')</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="content-section">
            <div class="container">
                <div class="section-header">
                    <h2>@lang('messages.fundamental_principles')</h2>
                    <p>@lang('messages.principles_description')</p>
                </div>

                <div class="principles-grid">
                    <div class="principle-item">
                        <h4><i class="fas fa-eye"></i> @lang('messages.transparency_title')</h4>
                        <p>@lang('messages.transparency_desc')</p>
                    </div>
                    <div class="principle-item">
                        <h4><i class="fas fa-universal-access"></i> @lang('messages.accessibility_title')</h4>
                        <p>@lang('messages.accessibility_desc')</p>
                    </div>
                    <div class="principle-item">
                        <h4><i class="fas fa-balance-scale"></i> @lang('messages.proportionality_title')</h4>
                        <p>@lang('messages.proportionality_desc')</p>
                    </div>
                    <div class="principle-item">
                        <h4><i class="fas fa-clock"></i> @lang('messages.quick_resolution_title')</h4>
                        <p>@lang('messages.quick_resolution_desc')</p>
                    </div>
                    <div class="principle-item">
                        <h4><i class="fas fa-book"></i> @lang('messages.recording_title')</h4>
                        <p>@lang('messages.recording_desc')</p>
                    </div>
                    <div class="principle-item">
                        <h4><i class="fas fa-map-marked-alt"></i> @lang('messages.site_visits_title')</h4>
                        <p>@lang('messages.site_visits_desc')</p>
                    </div>
                </div>
            </div>
        </section>

        <section class="content-section" id="contact">
            <div class="container">
                <div class="section-header">
                    <h2>@lang('messages.contact_methods')</h2>
                    <p>@lang('messages.choose_contact_method')</p>
                </div>

                <div class="contact-methods">
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-user"></i>
                        </div>
                        <h3>@lang('messages.in_person')</h3>
                        <p>@lang('messages.in_person_desc')</p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-users"></i>
                        </div>
                        <h3>@lang('messages.representation')</h3>
                        <p>@lang('messages.representation_desc')</p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <h3>@lang('messages.mail')</h3>
                        <p>@lang('messages.mail_desc')</p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-at"></i>
                        </div>
                        <h3>@lang('messages.email')</h3>
                        <p>@lang('messages.email_desc')</p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-phone"></i>
                        </div>
                        <h3>@lang('messages.phone')</h3>
                        <p>@lang('messages.phone_desc')</p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-globe"></i>
                        </div>
                        <h3>@lang('messages.website')</h3>
                        <p>@lang('messages.website_desc')</p>
                    </div>
                </div>
            </div>
        </section>

        <section class="content-section">
            <div class="container">
                <div class="section-header">
                    <h2>@lang('messages.roles_responsibilities')</h2>
                </div>

                <div class="process-grid">
                    <div class="process-card">
                        <div class="process-icon">
                            <i class="fas fa-users-cog"></i>
                        </div>
                        <h3>@lang('messages.regional_committees_title')</h3>
                        <p>@lang('messages.regional_committees_desc')</p>
                    </div>
                    <div class="process-card">
                        <div class="process-icon">
                            <i class="fas fa-inbox"></i>
                        </div>
                        <h3>@lang('messages.complaint_recipients_title')</h3>
                        <p>@lang('messages.complaint_recipients_desc')</p>
                    </div>
                    <div class="process-card">
                        <div class="process-icon">
                            <i class="fas fa-user-tie"></i>
                        </div>
                        <h3>@lang('messages.complaint_manager_title')</h3>
                        <p>@lang('messages.complaint_manager_desc')</p>
                    </div>
                    <div class="process-card">
                        <div class="process-icon">
                            <i class="fas fa-handshake"></i>
                        </div>
                        <h3>@lang('messages.stakeholders_title')</h3>
                        <p>@lang('messages.stakeholders_desc')</p>
                    </div>
                </div>
            </div>
        </section>
@endsection

@push('scripts')
<script>
    @isset($success) 
    showSuccessModal();
    @else
    console.log('Not successful');
    
    @endisset
    function showSuccessModal() {
            const referenceNumber = 'FIE-' + Date.now().toString().slice(-8);
            document.getElementById('referenceNumber').textContent = referenceNumber;
            document.getElementById('successModal').classList.add('show');
        }

        function closeSuccessModal() {
            document.getElementById('successModal').classList.remove('show');
            resetForm();
        }
</script>
@endpush

