@extends('layouts.app')

@section('content')
<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Propositions de résolution pour la plainte #{{ $plainte->numero }}</h5>
                    <a href="{{ route('plaintes.show', $plainte) }}" class="btn btn-light btn-sm">
                        <i class="fas fa-arrow-left me-1"></i> Retour à la plainte
                    </a>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if($resolutions->isEmpty())
                        <div class="text-center py-5">
                            <i class="fas fa-inbox fa-4x text-muted mb-3"></i>
                            <p class="h5 text-muted">Aucune proposition de résolution trouvée</p>
                            @can('create', [App\Models\Resolution::class, $plainte])
                                <a href="{{ route('plaintes.resolutions.create', $plainte) }}" class="btn btn-primary mt-3">
                                    <i class="fas fa-plus me-1"></i> Proposer une résolution
                                </a>
                            @endcan
                        </div>
                    @else
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Date de proposition</th>
                                        <th>Statut</th>
                                        <th>Proposé par</th>
                                        <th class="text-end">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($resolutions as $resolution)
                                        <tr>
                                            <td>{{ $resolution->date_proposition->format('d/m/Y H:i') }}</td>
                                            <td>
                                                @php
                                                    $statusClasses = [
                                                        'en_attente' => 'warning',
                                                        'acceptee' => 'success',
                                                        'refusee' => 'danger'
                                                    ];
                                                @endphp
                                                <span class="badge bg-{{ $statusClasses[$resolution->statut] ?? 'secondary' }}">
                                                    {{ ucfirst($resolution->statut) }}
                                                </span>
                                            </td>
                                            <td>{{ $resolution->proposer->name ?? 'Utilisateur supprimé' }}</td>
                                            <td class="text-end">
                                                <a href="{{ route('plaintes.resolutions.show', [$plainte, $resolution]) }}" 
                                                   class="btn btn-sm btn-outline-primary">
                                                    <i class="fas fa-eye"></i> Voir
                                                </a>
                                                @can('update', $resolution)
                                                    <a href="{{ route('plaintes.resolutions.edit', [$plainte, $resolution]) }}" 
                                                       class="btn btn-sm btn-outline-secondary">
                                                        <i class="fas fa-edit"></i> Modifier
                                                    </a>
                                                @endcan
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="d-flex justify-content-between align-items-center mt-4">
                            <div>
                                @can('create', [App\Models\Resolution::class, $plainte])
                                    <a href="{{ route('plaintes.resolutions.create', $plainte) }}" class="btn btn-primary">
                                        <i class="fas fa-plus me-1"></i> Nouvelle proposition
                                    </a>
                                @endcan
                            </div>
                            <div>
                                {{ $resolutions->links() }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection