@extends('layouts.app')

@section('content')
<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Proposer une résolution pour la plainte #{{ $plainte->numero }}</h5>
                </div>

                <div class="card-body">
                    <form action="{{ route('plaintes.resolutions.store', $plainte) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        
                        <div class="mb-4">
                            <label for="resolution" class="form-label">Description de la résolution <span class="text-danger">*</span></label>
                            <textarea name="resolution" id="resolution" class="form-control @error('resolution') is-invalid @enderror" 
                                      rows="6" required>{{ old('resolution') }}</textarea>
                            @error('resolution')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <div class="form-text">Décrivez en détail la résolution que vous proposez.</div>
                        </div>

                        <div class="mb-4">
                            <label for="fichiers" class="form-label">Pièces jointes (optionnel)</label>
                            <input type="file" class="form-control @error('fichiers.*') is-invalid @enderror" 
                                   id="fichiers" name="fichiers[]" multiple>
                            @error('fichiers.*')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <div class="form-text">Formats acceptés : JPG, PNG, PDF, DOC, DOCX, XLS, XLSX (max 10 Mo par fichier)</div>
                            <div id="fileList" class="mt-2"></div>
                        </div>

                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            Cette proposition sera envoyée au plaignant pour acceptation ou refus.
                        </div>

                        <div class="d-flex justify-content-between mt-4">
                            <a href="{{ route('plaintes.show', $plainte) }}" class="btn btn-outline-secondary">
                                <i class="fas fa-arrow-left me-1"></i> Annuler
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-paper-plane me-1"></i> Envoyer la proposition
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // File input preview
    const fileInput = document.getElementById('fichiers');
    if (fileInput) {
        fileInput.addEventListener('change', function(e) {
            const files = e.target.files;
            const fileList = document.getElementById('fileList');
            
            if (files.length > 0) {
                let fileListHTML = '<div class="alert alert-light p-2"><strong>Fichiers sélectionnés :</strong><ul class="mb-0">';
                for (let i = 0; i < files.length; i++) {
                    fileListHTML += `<li>${files[i].name} (${formatFileSize(files[i].size)})</li>`;
                }
                fileListHTML += '</ul></div>';
                fileList.innerHTML = fileListHTML;
            } else {
                fileList.innerHTML = '';
            }
        });
    }

    // Format file size
    function formatFileSize(bytes) {
        if (bytes === 0) return '0 Bytes';
        const k = 1024;
        const sizes = ['Bytes', 'KB', 'MB', 'GB'];
        const i = Math.floor(Math.log(bytes) / Math.log(k));
        return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
    }
});
</script>
@endpush