{{-- @extends('home.layout.app-form') --}}
@push('styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<style>
    .fade-in {
        animation: fadeIn 0.3s ease-in;
    }
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(-20px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .option-card {
        cursor: pointer;
        transition: all 0.3s ease;
        border: 2px solid #dee2e6;
        text-align: center;
        color:  #111;
        overflow-wrap: wrap;
    }
    .option-card:hover {
        border-color: #0d6efd;
        background-color: #f8f9fa;
        transform: translateY(-2px);
    }
    .option-card.selected {
        border-color: #0d6efd;
        background-color: #e7f1ff;
        box-shadow: 0 4px 12px rgba(13, 110, 253, 0.15);
    }
    .question-section {
        text-align: left;
        transition: opacity 0.3s ease;
    }
    .question-section.answered {
        opacity: 0.6;
    }
    
    .progress-bar {
        transition: width 0.5s ease;
    }
    .rounded{
        border-radius: 10px!important;
    }
   
</style>
@endpush
{{-- @section('content') --}}

<form id="preFormAnswers" method="GET" action="{{ route('plaintes.formulaire') }}" >
    <input type="hidden" id="type_plainte_field" name="type_plainte" value="" required>
    <input type="hidden" id="type_plaignant_field" name="type_plaignant" value="" required>
    <input type="hidden" id="anonyme_field" name="anonyme" value="" >
</form>

<!-- Questions Modal -->
<div class="modal fade" id="questionsModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content fade-in">
            <div class="modal-header border-0 pb-0">
                <div>
                    <h5 class="modal-title fw-bold fs-4">Avant de commencer</h5>
                    <p class="text-muted mb-0">Aidez-nous à comprendre vos besoins</p>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body px-4 py-3">
                <!-- Progress Bar -->
                <div class="mb-4">
                    <div class="d-flex justify-content-between text-muted small mb-2">
                        <span>Question <span id="currentQuestion">1</span> sur <span id="totalQuestions">1</span></span>
                        <span><span id="progressPercent">0</span>% Complete</span>
                    </div>
                    <div class="progress" style="height: 8px;">
                        <div id="progressBar" class="progress-bar bg-primary" role="progressbar" style="width: 0%"></div>
                    </div>
                </div>

                <!-- Question 1 -->
                <div class="question-section mb-4" data-question="type_plaignant">
                    <h6 class="fw-semibold mb-3">
                        <i class="bi bi-check-circle-fill text-success me-2 d-none"></i>
                        @lang('messages.who_are_you')
                    </h6>

                    <div class="row g-3" id="type_plaignant">
                            <div class="col-md-4">
                            <div class="option-card h-100 p-3 rounded" data-question="type_plaignant" data-value="individu">
                                <div class="fw-medium">@lang('messages.individual')</div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="option-card h-100 p-3 rounded" data-question="type_plaignant" data-value="groupe">
                                <div class="fw-medium">@lang('messages.group')</div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="option-card h-100 p-3 rounded" data-question="type_plaignant" data-value="communaute">
                                <div class="fw-medium">@lang('messages.community')</div>
                            </div>
                        </div>
                    </div>
                    
                    
                </div>

                <!-- Question 2 -->
                <div class="question-section mb-4"  data-question="type_plainte">
                    <h6 class="fw-semibold mb-3">
                        <i class="bi bi-check-circle-fill text-success me-2 d-none"></i>
                        @lang('messages.complaint_type')
                    </h6>
                    <div class="row g-3">
                        <div class="col-md-4">
                            <div class="option-card h-100 p-3 rounded" data-question="type_plainte" data-value="environnementale">
                                <div class="fw-medium">@lang('messages.environmental')</div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="option-card h-100 p-3 rounded" data-question="type_plainte" data-value="sociale">
                                <div class="fw-medium">@lang('messages.social')</div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="option-card h-100 p-3 rounded" data-question="type_plainte" data-value="genre">
                                <div class="fw-medium">@lang('messages.other')</div>
                            </div>
                        </div>
                        
                    </div>
                </div>
                <!-- Question 3 -->
                <div class="question-section mb-4" data-question="anonyme">
                    <h6 class="fw-semibold mb-3">
                        <i class="bi bi-check-circle-fill text-success me-2 d-none"></i>
                        @lang('messages.anonymous_complaint')
                    </h6>
                    <div class="row g-3">
                        <div class="col-md-3">
                            <div class="option-card h-100 p-3 rounded" data-question="anonyme" data-value="1">
                                <div class="fw-medium">@lang('messages.yes')</div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="option-card h-100 p-3 rounded" data-question="anonyme" data-value="0">
                                <div class="fw-medium">@lang('messages.no')</div>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
            <div class="modal-footer border-0 pt-0">
                <button type="button" class="btn btn-primary btn-lg px-4" id="continueBtn" disabled>
                    @lang('messages.continue') <i class="fa fa-arrow-right ms-2"></i>
                </button>
            </div>
        </div>
    </div>
</div>

<div class="success-modal" id="successModal">
    <div class="success-content">
        <div class="success-icon">
            <i class="fas fa-check-circle"></i>
        </div>
        <h2>@lang('messages.submission_success')</h2>
        <p>@lang('messages.submission_success_message')</p>
        <p style="margin-top: 1rem; color: #666;">
            @lang('messages.submission_confirmation')
        </p>
        <button class="btn btn-primary" onclick="closeSuccessModal()" style="margin-top: 1.5rem;">
            <i class="fas fa-home"></i>
            @lang('messages.return_home')
        </button>
    </div>
</div>

{{-- @endsection --}}
@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
        // Initialize
        const answers = {
            type_plainte: null,
            type_plaignant: null,
            anonyme: null,
        };

        const questionsModal = new bootstrap.Modal(document.getElementById('questionsModal'));
        const preFormAnswers = document.getElementById('preFormAnswers');
    
        const typePlainteInput = document.getElementById('type_plainte_field');
        const typePlaignantInput = document.getElementById('type_plaignant_field');
        const anonymeInput = document.getElementById('anonyme_field');
        // Show questions modal on page load
        //Use foreach on buttons
    
    //On bootstrap modal close

    $("#questionsModal").on('hidden.bs.modal', function () {
        reinitAnswers();
    });


    
    // Handle option selection
    document.querySelectorAll('#questionsModal .option-card').forEach(card => {
        card.addEventListener('click', function() {
            const question = this.dataset.question;
            const value = this.dataset.value;
        
            // Remove selected class from siblings
            document.querySelectorAll(`#questionsModal .option-card[data-question="${question}"]`).forEach(c => {
                c.classList.remove('selected');
            });
            
            // Add selected class to clicked card
            this.classList.add('selected');
            
            // Store answer
            answers[question] = value;   
            if(question=='anonyme') anonymeInput.value=value;       
            if(question=='type_plainte') typePlainteInput.value=value;       
            if(question=='type_plaignant') typePlaignantInput.value=value;       
            // Update UI
            updateProgress();
            updateContinueButton();
            markQuestionAnswered(question);
        });
    });


    function reinitAnswers(){
        answers.type_plainte=null;
        answers.type_plaignant=null;
        answers.anonyme=null;
        document.querySelectorAll('#questionsModal .option-card').forEach(card => {
            card.classList.remove('selected');
        });
        //Reset select fields
        typePlaignantInput.value = '';
        typePlainteInput.value = '';
        anonymeInput.value = '';

        document.querySelectorAll('.question-section').forEach(section => {
            section.classList.remove('answered');
            section.querySelector('.bi-check-circle-fill').classList.add('d-none');
        });
        updateProgress();
        updateContinueButton();
    }


    // Update progress bar
    function updateProgress() {
        let answered = Object.values(answers).filter(a => a !== null).length;
        const total = Object.keys(answers).length;
        const percent = Math.round((answered / total) * 100);
        
        document.getElementById('currentQuestion').textContent = Math.min(answered + 1, total);
        document.getElementById('totalQuestions').textContent = total;
        document.getElementById('progressPercent').textContent = percent;
        document.getElementById('progressBar').style.width = percent + '%';
    }

    // Mark question as answered
    function markQuestionAnswered(question) {
        const section = document.querySelector(`.question-section[data-question="${question}"]`);
        const icon = section.querySelector('.bi-check-circle-fill');
        section.classList.add('answered');
        icon.classList.remove('d-none');
    }

    // Update continue button state
    function updateContinueButton() {
        const allAnswered = Object.values(answers).every(a => a !== null);
        document.getElementById('continueBtn').disabled = !allAnswered;
    }

    // Continue to documents modal
    document.getElementById('continueBtn').addEventListener('click', function() {
        preFormAnswers.submit();
    });

});

</script>   
@endpush