@extends('layouts.front')
@push('styles')
<link rel="stylesheet" href="{{ asset('assets/css/form.css') }}">
<style>
    .list-container {
        background-color: #fff;
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }
</style>
@endpush
@section('content')
    <div class="container py-3">
        

        <!-- Liste des plaintes -->
        <div class="list-container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2>@lang('messages.list_of_plaintes')</h2>
                {{-- <a href="{{ route('plaintes.formulaire') }}" class="btn btn-xs btn-primary">
                    <i class="fas fa-plus"></i> @lang('messages.new_complaint')
                </a> --}}
            </div>
            
            <!-- Filters -->
            <div class="card mb-4">
                <div class="card-body">
                    <form method="GET" action="{{ route('plaintes.liste') }}" id="filterForm">
                        <div class="row g-3">
                            <div class="col-md-3">
                                <label class="form-label">@lang('messages.status')</label>
                                <select name="status" class="form-select">
                                    <option value="">@lang('messages.all_statuses')</option>
                                    <option value="nouveau" {{ request('status') == 'nouveau' ? 'selected' : '' }}>@lang('messages.new')</option>
                                    <option value="en_cours" {{ request('status') == 'en_cours' ? 'selected' : '' }}>@lang('messages.in_progress')</option>
                                    <option value="traite" {{ request('status') == 'traite' ? 'selected' : '' }}>@lang('messages.processed')</option>
                                    <option value="ferme" {{ request('status') == 'ferme' ? 'selected' : '' }}>@lang('messages.closed')</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">@lang('messages.from_date')</label>
                                <input type="date" name="from_date" class="form-control" value="{{ request('from_date') }}">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">@lang('messages.to_date')</label>
                                <input type="date" name="to_date" class="form-control" value="{{ request('to_date') }}">
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-xs btn-primary me-2">
                                    <i class="fas fa-filter"></i> @lang('messages.filter')
                                </button>
                                <a href="{{ route('plaintes.liste') }}" class="btn btn-xs btn-secondary">
                                    <i class="fas fa-redo"></i>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            
            <div class="table-responsive">
                <table class="table table-hover">
                <thead>
                    <tr>
                        <th>@lang('messages.reference')</th>
                        <th>@lang('messages.date')</th>
                        <th>@lang('messages.object')</th>
                        <th>@lang('messages.status')</th>
                        {{-- <th>@lang('messages.actions')</th> --}}
                    </tr>
                </thead>
                <tbody>
                    @foreach ($plaintes as $plainte)
                        <tr>
                            <td>{{ $plainte->reference }}</td>
                            <td>{{ $plainte->date_reception }}</td>
                            <td>{{ $plainte->objet }}</td>
                            <td>{{ $plainte->statut }}</td>
                            {{-- <td>
                                <a href="{{ route('plaintes.show', $plainte->id) }}" class="btn btn-xs btn-primary btn-sm">
                                    @lang('messages.view')
                                </a>
                            </td> --}}
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    

    
@endsection
@push('styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>
    // Initialize date picker
    document.addEventListener('DOMContentLoaded', function() {
        flatpickr("input[type=date]", {
            dateFormat: "Y-m-d",
            allowInput: true
        });
        
        // Reset form
        document.getElementById('resetFilters').addEventListener('click', function() {
            document.getElementById('filterForm').reset();
            window.location.href = "{{ route('plaintes.liste') }}";
        });
    });
        // Progress tracking
        const form = document.getElementById('fundingForm');
        const progressFill = document.getElementById('progressFill');
        const progressText = document.getElementById('progressText');

        function updateProgress() {
            const inputs = form.querySelectorAll('input[required], textarea[required], select[required]');
            let filled = 0;
            
            inputs.forEach(input => {
                if (input.value.trim() !== '') {
                    filled++;
                }
            });
            
            const percentage = Math.round((filled / inputs.length) * 100);
            progressFill.style.width = percentage + '%';
            progressText.textContent = percentage + '% ' + '@lang('messages.complete')';
        }

        // Add event listeners to all form inputs
        form.addEventListener('input', updateProgress);
        form.addEventListener('change', updateProgress);

        // File upload handling
        const fileInput = document.getElementById('fileInput');
        const fileList = document.getElementById('fileList');
        let uploadedFiles = [];

        fileInput.addEventListener('change', function(e) {
            Array.from(e.target.files).forEach(file => {
                if (file.size > 10 * 1024 * 1024) {
                    alert(`@lang('messages.file_too_large') ${file.name}`);
                    return;
                }
                
                if (!uploadedFiles.find(f => f.name === file.name)) {
                    uploadedFiles.push(file);
                    addFileToList(file);
                }
            });
            updateProgress();
        });

        function addFileToList(file) {
            const fileItem = document.createElement('div');
            fileItem.className = 'file-item';
            fileItem.innerHTML = `
                <div class="file-item-info">
                    <i class="fas fa-file-${getFileIcon(file.name)}"></i>
                    <span>${file.name} (${(file.size / 1024 / 1024).toFixed(2)} MB)</span>
                </div>
                <button type="button" class="remove-file" onclick="removeFile('${file.name}')">
                    <i class="fas fa-times"></i>
                </button>
            `;
            fileList.appendChild(fileItem);
        }

        function getFileIcon(filename) {
            const ext = filename.split('.').pop().toLowerCase();
            const icons = {
                'pdf': 'pdf',
                'doc': 'word',
                'docx': 'word',
                'xls': 'excel',
                'xlsx': 'excel'
            };
            return icons[ext] || 'alt';
        }

        function removeFile(filename) {
            uploadedFiles = uploadedFiles.filter(f => f.name !== filename);
            const items = fileList.querySelectorAll('.file-item');
            items.forEach(item => {
                if (item.textContent.includes(filename)) {
                    item.remove();
                }
            });
            updateProgress();
        }




        // Validate numeric inputs
        const numericInputs = form.querySelectorAll('input[type="number"]');
        numericInputs.forEach(input => {
            input.addEventListener('input', function() {
                if (this.value < 0) {
                    this.value = 0;
                }
            });
        });

        

        // Initialize progress on load
        updateProgress();

        // Smooth scroll to top button
        window.addEventListener('scroll', function() {
            const scrollBtn = document.getElementById('scrollTopBtn');
            if (!scrollBtn) {
                const btn = document.createElement('button');
                btn.id = 'scrollTopBtn';
                btn.innerHTML = '<i class="fas fa-arrow-up"></i>';
                btn.style.cssText = `
                    position: fixed;
                    bottom: 2rem;
                    right: 2rem;
                    width: 50px;
                    height: 50px;
                    border-radius: 50%;
                    background: linear-gradient(135deg, #2e8b57, #228b22);
                    color: white;
                    border: none;
                    cursor: pointer;
                    display: none;
                    align-items: center;
                    justify-content: center;
                    font-size: 1.2rem;
                    box-shadow: 0 4px 15px rgba(46, 139, 87, 0.3);
                    transition: all 0.3s ease;
                    z-index: 1000;
                `;
                btn.addEventListener('click', function() {
                    window.scrollTo({ top: 0, behavior: 'smooth' });
                });
                document.body.appendChild(btn);
            }
            
            const scrollTopBtn = document.getElementById('scrollTopBtn');
            if (window.pageYOffset > 300) {
                scrollTopBtn.style.display = 'flex';
            } else {
                scrollTopBtn.style.display = 'none';
            }
        });
    </script> 
    <script>
        (function () {
            'use strict'
            var forms = document.querySelectorAll('.needs-validation')
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
@endpush
