@extends('layouts.app')


@section('content')
<div class="container">

    <div class="col-md-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Accueil</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Nouvelle plainte</li>
                </ol>
            </nav>

    </div>

    <div class="row">
        <div class="col-md-12 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h4>Nouvelle Plainte</h4>
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form method="POST" action="{{ route('plaintes.store') }}" enctype="multipart/form-data">
                        @csrf
                        
                        <!-- Informations du plaignant -->
                        <h5>Informations du Plaignant</h5>
                        <div class="mb-3">
                            <label class="form-label">Type de plaignant *</label>
                            <select name="plaignant[type]"  class="form-select" required>
                                <option value="individu">Individu</option>
                                <option value="groupe">Groupe</option>
                                <option value="communaute">Communaute</option>
                            </select>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Nom *</label>
                                <input type="text" name="plaignant[nom]" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Prénom</label>
                                <input type="text" name="plaignant[prenom]" class="form-control">
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Téléphone</label>
                                <input type="tel" name="plaignant[telephone]" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Email</label>
                                <input type="email" name="plaignant[email]" class="form-control">
                            </div>
                        </div>

                        <!-- Informations de la plainte -->
                        <h5 class="mt-4">Détails de la Plainte</h5>
                        <div class="mb-3">
                            <label class="form-label">Objet de la plainte *</label>
                            <input type="text" name="objet" class="form-control" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Description détaillée *</label>
                            <textarea name="description" class="form-control" rows="5" required></textarea>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label class="form-label">Canal de réception</label>
                                <select name="canal_reception" class="form-select" required>
                                    <option value="web">Site Web</option>
                                    <option value="email">Email</option>
                                    <option value="telephone">Téléphone</option>
                                    <option value="courrier_physique">Courrier</option>
                                    <option value="boite_plaintes">Boîte à plaintes</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Type de plainte</label>
                                <select name="type_plainte" class="form-select" required>
                                    <option value="sociale">Sociale</option>
                                    <option value="environnementale">Environnementale</option>
                                    <option value="genre">Genre</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check mt-4">
                                    <input type="hidden" name="est_anonyme" value="0">
                                    <input type="checkbox" name="est_anonyme" value="1" class="form-check-input" id="est_anonyme">
                                    <label class="form-check-label" for="est_anonyme">Plainte anonyme</label>
                                </div>
                                <div class="form-check">
                                    <input type="hidden" name="est_lanceur_alerte" value="0">
                                    <input type="checkbox" name="est_lanceur_alerte" value="1" class="form-check-input" id="est_lanceur_alerte">
                                    <label class="form-check-label" for="est_lanceur_alerte">Lanceur d'alerte</label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Pièces justificatives</label>
                            <input type="file" name="preuves[]" class="form-control" multiple 
                                   accept=".pdf,.doc,.docx,.jpg,.jpeg,.png,.mp3,.mp4">
                            <small class="form-text text-muted">
                                Formats acceptés: PDF, DOC, DOCX, JPG, PNG, MP3, MP4 (Max: 10MB par fichier)
                            </small>
                        </div>
                        
                        <div class="d-flex justify-content-between">
                            <a href="{{ route('plaintes.index') }}" class="btn btn-secondary">Annuler</a>
                            <button type="submit" class="btn btn-primary">Enregistrer la Plainte</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection