@extends('layouts.front')
@push('styles')
    <style>
        /* Form Styles */
        .form-section {
            margin-bottom: 2rem;
        }

        .form-section h5 {
            color: #333;
            font-size: 1.3rem;
            margin-bottom: 1rem;
            padding-bottom: 0.5rem;
            border-bottom: 2px solid #f0f0f0;
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
            margin-bottom: 1rem;
        }

        .form-row.single {
            grid-template-columns: 1fr;
        }

        .form-row.triple {
            grid-template-columns: 1fr 1fr 1fr;
        }

        .form-group {
            margin-bottom: 1rem;
        }

        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #333;
        }

        .form-label.required::after {
            content: " *";
            color: #dc3545;
        }

        .form-control, .form-select {
            width: 100%;
            padding: 0.8rem;
            border: 2px solid #e9ecef;
            border-radius: 10px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: white;
        }

        .form-control:focus, .form-select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .form-control.textarea {
            resize: vertical;
            min-height: 120px;
        }

        .form-check {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin-bottom: 0.5rem;
        }

        .form-check-input {
            width: 18px;
            height: 18px;
            margin: 0;
        }

        .form-check-label {
            font-weight: normal;
            margin: 0;
        }

        .file-upload {
            position: relative;
        }

        .file-upload input[type="file"] {
            opacity: 0;
            position: absolute;
            z-index: -1;
        }

        .file-upload-label {
            display: block;
            padding: 1rem;
            border: 2px dashed #ccc;
            border-radius: 10px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            background: #f8f9fa;
        }

        .file-upload-label:hover {
            border-color: #667eea;
            background: rgba(102, 126, 234, 0.1);
        }

        .form-text {
            font-size: 0.9rem;
            color: #6c757d;
            margin-top: 0.5rem;
        }

        .form-actions {
            display: flex;
            justify-content: space-between;
            gap: 1rem;
            padding-top: 1rem;
            border-top: 1px solid #e9ecef;
            margin-top: 2rem;
        }

        .btn-cancel {
            background: #6c757d;
            color: white;
        }

        .btn-cancel:hover {
            background: #5a6268;
        }

        @media (max-width: 768px) {
            .modal-content {
                margin: 1rem;
                max-height: calc(100vh - 2rem);
            }

            .form-row {
                grid-template-columns: 1fr;
            }

            .form-row.triple {
                grid-template-columns: 1fr;
            }

            .form-actions {
                flex-direction: column;
            }
        }
        
        .alert {
            border-radius: 5px;
            padding: 10px;
            margin-bottom: 10px;
        }
        .alert-danger {
            color: #721c24;
            background-color: #f8d7da;
            border-color: #f5c6cb;
        }
    </style>
@endpush
@section('content')
        <section class="content-section" id="processus">
            <div class="container">
                <div class="section-header">
                    <h2>Déposer une plainte</h2>
                    <p>Un système transparent et efficace en 8 étapes pour traiter vos préoccupations</p>
                </div>
                @if($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <form method="POST" action="{{ route('plaintes.store') }}" enctype="multipart/form-data">
                    @csrf
                    
                    <div id="plainteForm">
                        <!-- Informations du plaignant -->
                        <div class="form-section">
                            <h5><i class="fas fa-user"></i> Informations du Plaignant</h5>
                            <div class="mb-3">
                            <div class="d-flex gap-2">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary" id="est_anonyme_button">
                                        <input type="hidden" name="est_anonyme" value="0">
                                        <input type="checkbox" name="est_anonyme" value="1" class="form-check-input" id="est_anonyme">
                                        <span class="btn-label">Plainte anonyme</span>
                                    </button>
                                </div>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary" id="est_lanceur_alerte_button">
                                        <input type="hidden" name="est_lanceur_alerte" value="0">
                                        <input type="checkbox" name="est_lanceur_alerte" value="1" class="form-check-input" id="est_lanceur_alerte">
                                        <span class="btn-label">Lanceur d'alerte</span>
                                    </button>
                                </div>
                            </div>
                            
                                <label class="form-label">Type de plaignant *</label>
                                <select name="plaignant[type]"  class="form-select" required>
                                    <option value="individu">Individu</option>
                                    <option value="groupe">Groupe</option>
                                    <option value="communaute">Communaute</option>
                                </select>
                            </div>
                            <div class="form-row">
                                <div class="form-group">
                                    <label class="form-label required">Nom</label>
                                    <input type="text" name="plaignant[nom]" class="form-control" required>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">Prénom</label>
                                    <input type="text" name="plaignant[prenom]" class="form-control">
                                </div>
                            </div>
                            
                            <div class="form-row">
                                <div class="form-group">
                                    <label class="form-label">Téléphone</label>
                                    <input type="tel" name="plaignant[telephone]" class="form-control">
                                </div>
                                <div class="form-group">
                                    <label class="form-label">Email</label>
                                    <input type="email" name="plaignant[email]" class="form-control">
                                </div>
                            </div>
                        </div>
    
                        <!-- Informations de la plainte -->
                        <div class="form-section">
                            <h5><i class="fas fa-exclamation-circle"></i> Détails de la Plainte</h5>
                            <div class="form-group">
                                <label class="form-label required">Objet de la plainte</label>
                                <input type="text" name="objet" class="form-control" required>
                            </div>
                            
                            <div class="form-group">
                                <label class="form-label required">Description détaillée</label>
                                <textarea name="description" class="form-control textarea" rows="5" required placeholder="Décrivez votre plainte de manière détaillée..."></textarea>
                            </div>
                            
                            <div class="form-row triple">
                                <div class="form-group">
                                    <label class="form-label required">Canal de réception</label>
                                    <select name="canal_reception" class="form-select" required>
                                        <option value="">Choisissez...</option>
                                        <option value="web">Site Web</option>
                                        <option value="email">Email</option>
                                        <option value="telephone">Téléphone</option>
                                        <option value="courrier_physique">Courrier</option>
                                        <option value="boite_plaintes">Boîte à plaintes</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label class="form-label required">Type de plainte</label>
                                    <select name="type_plainte" class="form-select" required>
                                        <option value="">Choisissez...</option>
                                        <option value="sociale">Sociale</option>
                                        <option value="environnementale">Environnementale</option>
                                        <option value="genre">Genre</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">Options</label>
                                    <div class="form-check">
                                        <input type="hidden" name="est_anonyme" value="0">
                                        <input type="checkbox" name="est_anonyme" value="1" class="form-check-input" id="est_anonyme">
                                        <label class="form-check-label" for="est_anonyme">Plainte anonyme</label>
                                    </div>
                                    <div class="form-check">
                                        <input type="hidden" name="est_lanceur_alerte" value="0">
                                        <input type="checkbox" name="est_lanceur_alerte" value="1" class="form-check-input" id="est_lanceur_alerte">
                                        <label class="form-check-label" for="est_lanceur_alerte">Lanceur d'alerte</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label class="form-label">Pièces justificatives</label>
                                <div class="file-upload">
                                    <input type="file" name="preuves" class="form-control" multiple accept=".pdf,.doc,.docx,.jpg,.jpeg,.png,.mp3,.mp4" id="fileInput">
                                    <label for="fileInput" class="file-upload-label">
                                        <i class="fas fa-cloud-upload-alt"></i><br>
                                        Cliquez pour sélectionner des fichiers<br>
                                        <span class="form-text">Formats acceptés: PDF, DOC, DOCX, JPG, PNG, MP3, MP4 (Max: 10MB par fichier)</span>
                                    </label>
                                </div>
                                <div id="fileList" class="mt-2"></div>
                            </div>
                        </div>
                        
                        <div class="form-actions">
                            <button type="reset" class="btn btn-cancel">
                                <i class="fas fa-times"></i> Annuler
                            </button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-paper-plane"></i> Enregistrer la Plainte
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </section>



@endsection
@push('scripts')
<script>
    // Handle file upload display
    document.getElementById('fileInput').addEventListener('change', function(e) {
            const fileList = document.getElementById('fileList');
            fileList.innerHTML = '';
            
            if (e.target.files.length > 0) {
                const fileContainer = document.createElement('div');
                fileContainer.style.marginTop = '1rem';
                
                Array.from(e.target.files).forEach(file => {
                    const fileItem = document.createElement('div');
                    fileItem.style.cssText = `
                        padding: 0.5rem;
                        background: #f8f9fa;
                        border: 1px solid #dee2e6;
                        border-radius: 5px;
                        margin-bottom: 0.5rem;
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                    `;
                    
                    fileItem.innerHTML = `
                        <span><i class="bi bi-file"></i> ${file.name} (${(file.size / 1024 / 1024).toFixed(2)} MB)</span>
                    `;
                    
                    fileContainer.appendChild(fileItem);
                });
                
                fileList.appendChild(fileContainer);
            }
        });

        // Handle anonymous checkbox
        document.getElementById('est_anonyme').addEventListener('change', function() {
            const personalInfoFields = document.querySelectorAll('input[e^="gplaignant["]');]
            personalInfoFields.forEach(field => {
                if (this.checked) {
                    field.disabled = true;
                    field.style.opacity = '0.5';
                    field.value = '';
                } else {
                    field.disabled = false;
                    field.style.opacity = '1';
                }
            });
        });
</script>
    
@endpush