@extends('layouts.app')

@push('styles')
<style>
.label {
    font-weight: bold;
}
</style>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-12 d-flex align-items-center justify-content-between">
            <h2 class="mb-0">Détails de la Demande de Financement</h2>
            <div>
                <a href="{{ route('financements.index') }}" class="btn btn-secondary">
                    <i class="bi bi-arrow-left me-1"></i> Retour
                </a>
                {{-- @can('update', $financement) --}}
                <a href="{{ route('financements.edit', $financement) }}" class="btn btn-primary">
                    <i class="bi bi-pencil me-1"></i> Modifier
                </a>
                {{-- @endcan --}}
            </div>
        </div>
    </div>
<!-- Actions -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <strong>Actions</strong>
            </div>
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                            {{-- @if(auth()->user()->hasRole('admin')) --}}
                                @if($financement->statut === 'en_attente')
                                    <form action="{{ route('financements.update-status', $financement) }}" method="POST" class="d-inline me-2">
                                        @csrf
                                        @method('PATCH')
                                        <input type="hidden" name="statut" value="en_cours">
                                        <button type="submit" class="btn btn-info text-white">
                                            <i class="bi bi-play-circle me-1"></i> Mettre en cours de traitement
                                        </button>
                                    </form>
                                @endif
                                
                                @if($financement->statut === 'en_cours')
                                    <button type="button" class="btn btn-success me-2" data-bs-toggle="modal" data-bs-target="#approveModal">
                                        <i class="bi bi-check-circle me-1"></i> Approuver
                                    </button>
                                    
                                    <button type="button" class="btn btn-danger me-2" data-bs-toggle="modal" data-bs-target="#rejectModal">
                                        <i class="bi bi-times-circle me-1"></i> Rejeter
                                    </button>
                                @endif
                                
                               
                            {{-- @endif --}}
                        {{-- @endcan --}}
                    </div>
                    
                    {{-- @can('delete', $financement) --}}
                    @if(in_array($financement->statut, ['approuve', 'rejete']))
                    <form action="{{ route('financements.update-status', $financement) }}" method="POST" class="d-inline me-2">
                        @csrf
                        @method('PATCH')
                        <input type="hidden" name="statut" value="archive">
                        <button type="submit" class="btn btn-outline-warning ">
                            <i class="bi bi-archive me-1"></i>Archiver
                        </button>
                    </form>
                    @endif
                    {{-- @endcan --}}
                </div>
            </div>
        </div>
    </div>
</div>
    <div class="row g-3">
        <!-- Informations Générales -->
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <strong>Référence :</strong> {{ $financement->reference }}
                    </div>
                    <div>
                        @php
                            $statusColors = [
                                'en_attente' => 'bg-warning',
                                'en_cours' => 'bg-info',
                                'approuve' => 'bg-success',
                                'rejete' => 'bg-danger',
                                'archive' => 'bg-warning',
                            ];
                            $statusLabels = [
                                'en_attente' => 'En Attente',
                                'en_cours' => 'En Cours de traitement',
                                'approuve' => 'Approuvé',
                                'rejete' => 'Rejeté',
                                'archive' => 'Cloturé',
                            ];
                        @endphp
                        <span class="badge {{ $statusColors[$financement->statut] ?? 'bg-secondary' }}">
                            {{ $statusLabels[$financement->statut] ?? $financement->statut }}
                        </span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <div class="label">Nom de la structure</div>
                                <div class="value">{{ $financement->nom_structure }}</div>
                            </div>
                            <div class="mb-3">
                                <div class="label">Email</div>
                                <div class="value">{{ $financement->email }}</div>
                            </div>
                            <div class="mb-3">
                                <div class="label">Telephone</div>
                                <div class="value">{{ $financement->telephone }}</div>
                            </div>
                            <div class="mb-3">
                                <div class="label">Statut juridique</div>
                                <div class="value text-capitalize">{{ $financement->statut_juridique }}</div>
                            </div>
                            <div class="mb-3">
                                <div class="label">Numéro IFU</div>
                                <div class="value">{{ $financement->numero_ifu }}</div>
                            </div>
                            <div class="mb-3">
                                <div class="label">Numéro RCCM</div>
                                <div class="value">{{ $financement->numero_rccm }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <div class="label">Région</div>
                                <div class="value">{{ $financement->region }}</div>
                            </div>
                            <div class="mb-3">
                                <div class="label">Commune</div>
                                <div class="value">{{ $financement->commune }}</div>
                            </div>
                            <div class="mb-3">
                                <div class="label">Personne habilitée</div>
                                <div class="value">{{ $financement->personne_habilitee }}</div>
                            </div>
                            <div class="mb-3">
                                <div class="label">Date de soumission</div>
                                <div class="value">{{ $financement->created_at->format('d/m/Y à H:i') }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Détails de l'Activité -->
            <div class="card mt-4">
                <div class="card-header">
                    <strong>Détails de l'Activité</strong>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <div class="label">Intitulé de l'activité</div>
                        <div class="value">{{ $financement->intitule_activite }}</div>
                    </div>
                    <div class="mb-3">
                        <div class="label">Résumé de l'activité</div>
                        <div class="value">{{ $financement->resume_activite }}</div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <div class="label">Période de mise en œuvre</div>
                                <div class="value">{{ $financement->periode_mise_en_oeuvre }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <div class="label">Organisations partenaires</div>
                                <div class="value">{{ $financement->organisations_partenaires ?? 'Aucun partenaire mentionné' }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Résultats Attendus -->
            <div class="card mt-4">
                <div class="card-header">
                    <strong>Résultats Attendus</strong>
                </div>
                <div class="card-body">
                    <ol>
                        @for($i = 1; $i <= 6; $i++)
                            @php $resultat = 'resultat_' . $i; @endphp
                            @if(!empty($financement->$resultat))
                                <li>{{ $financement->$resultat }}</li>
                            @endif
                        @endfor
                    </ol>
                </div>
            </div>
             <!-- Cibles et Visibilité -->
             <div class="card mt-4">
                <div class="card-header">
                    <strong>Cibles et Visibilité</strong>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <div class="label">Cibles principales</div>
                        <ul class="list-unstyled">
                            @for($i = 1; $i <= 4; $i++)
                                @php $cible = 'cible_' . $i; @endphp
                                @if(!empty($financement->$cible))
                                    <li><i class="bi bi-check-circle text-success me-2"></i> {{ $financement->$cible }}</li>
                                @endif
                            @endfor
                        </ul>
                    </div>
                    <div class="mb-3">
                        <div class="label">Contribution à la visibilité du FIE</div>
                        <div class="value">{{ $financement->contribution_visibilite }}</div>
                    </div>
                </div>
            </div>
            
        </div>

        <!-- Informations Financières -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <strong>Informations Financières</strong>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <div class="label">Coût total du projet</div>
                        <div class="value h5 text-primary">{{ number_format($financement->cout_total, 0, ',', ' ') }} FCFA</div>
                    </div>
                    <div class="mb-3">
                        <div class="label">Montant sollicité</div>
                        <div class="value h5 text-success">{{ number_format($financement->montant_sollicite, 0, ',', ' ') }} FCFA</div>
                    </div>
                    <div class="mb-3">
                        <div class="label">Guichet(s) ciblé(s)</div>
                        <div class="value">
                            @if(is_array($financement->guichet))
                                @foreach($financement->guichet as $guichet)
                                    <span class="badge bg-info me-1">{{ $guichet }}</span>
                                @endforeach
                            @else
                                <span class="text-muted">Non spécifié</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
    </div>
    <!-- Pièces Jointes -->
    <div class="card mt-4">
        <div class="card-header">
            <strong>Pièces Jointes</strong>
        </div>
        <div class="card-body">
            @if($financement->media->count() > 0)
                <div class="list-group">
                    @foreach($financement->media as $media)
                        <a target="_blank" href="{{ asset('storage/'.$media->chemin) }}" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                            <div class="d-flex align-items-center">
                                <i class="bi {{ in_array($media->type, ['pdf']) ? 'bi-file-pdf text-danger' : 'fa-file-word text-primary' }} me-2"></i>
                                <span>{{ $media->nom }}</span>
                            </div>
                            <span class="badge bg-light text-dark">{{ strtoupper($media->type) }}</span>
                        </a>
                    @endforeach
                </div>
            @else
                <div class="text-muted">Aucune pièce jointe disponible</div>
            @endif
        </div>
    </div>
    
</div>

<!-- Approve Modal -->
<div class="modal fade" id="approveModal" tabindex="-1" aria-labelledby="approveModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('financements.update-status', $financement) }}" method="POST">
                @csrf
                @method('PATCH')
                <input type="hidden" name="statut" value="approuve">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title" id="approveModalLabel">Confirmer l'approbation</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Êtes-vous sûr de vouloir approuver cette demande de financement ?</p>
                    <div class="mb-3">
                        <label for="commentaire" class="form-label">Commentaire (optionnel) :</label>
                        <textarea class="form-control" id="commentaire" name="commentaire" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-success">Confirmer l'approbation</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="rejectModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('financements.update-status', $financement) }}" method="POST">
                @csrf
                @method('PATCH')
                <input type="hidden" name="statut" value="rejete">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title" id="rejectModalLabel">Confirmer le rejet</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Êtes-vous sûr de vouloir rejeter cette demande de financement ?</p>
                    <div class="mb-3">
                        <label for="commentaire" class="form-label">Motif du rejet :</label>
                        <textarea class="form-control" id="commentaire" name="commentaire" rows="3" required></textarea>
                        <div class="form-text">Veuillez fournir une explication pour le rejet de cette demande.</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-danger">Confirmer le rejet</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Script pour confirmer la suppression
    function confirmDelete(id) {
        if (confirm('Êtes-vous sûr de vouloir supprimer cette demande de financement ? Cette action est irréversible.')) {
            document.getElementById('delete-form-' + id).submit();
        }
    }

    // Initialiser les tooltips Bootstrap
    document.addEventListener('DOMContentLoaded', function() {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
</script>
@endpush

@endsection
