@extends('layouts.email')

@section('content')
    <p>Bonjour,</p>
    
    <p>Une nouvelle proposition de résolution a été soumise pour la plainte #{{ $resolution->plainte->numero }}.</p>
    
    <div class="card">
        <div class="card-body">
            <h5>Détails de la proposition :</h5>
            <p>{!! nl2br(e($resolution->resolution)) !!}</p>
            
            @if($resolution->media->count() > 0)
                <div class="mt-3">
                    <h6>Pièces jointes :</h6>
                    <ul>
                        @foreach($resolution->media as $media)
                            <li>
                                <a href="{{ Storage::disk('public')->url($media->file_path) }}" target="_blank">
                                    {{ $media->file_name }}
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>
    </div>
    
    <div class="mt-4 text-center">
        <a href="{{ route('plaintes.show', $resolution->plainte) }}" class="btn btn-primary">
            Voir les détails de la plainte
        </a>
    </div>
    
    <p class="mt-4">
        Cordialement,<br>
        L'équipe de gestion des plaintes
    </p>
@endsection