<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Plainte déclarée irrecevable</title>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body, html {
            margin: 0;
            padding: 0;
            font-family: 'Nunito', Arial, sans-serif;
            line-height: 1.6;
            color: #333333;
            background-color: #f4f4f4;
            -webkit-font-smoothing: antialiased;
        }
        
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        
        .email-header {
            background-color: #1a365d;
            padding: 25px 30px;
            text-align: center;
            border-bottom: 5px solid #e2a03f;
        }
        
        .email-logo {
            max-width: 180px;
            height: auto;
        }
        
        .email-body {
            padding: 30px;
        }
        
        .email-footer {
            background-color: #f8f9fa;
            padding: 20px 30px;
            text-align: center;
            font-size: 13px;
            color: #6c757d;
            border-top: 1px solid #e9ecef;
        }
        
        h1, h2, h3, h4 {
            color: #1a365d;
            margin-top: 0;
            font-weight: 700;
        }
        
        h1 {
            font-size: 24px;
            margin-bottom: 20px;
        }
        
        p {
            margin: 0 0 15px 0;
            font-size: 16px;
            color: #4a5568;
        }
        
        .card {
            background: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .card-title {
            font-size: 16px;
            font-weight: 700;
            color: #1a365d;
            margin: 0 0 15px 0;
            padding-bottom: 10px;
            border-bottom: 1px solid #e2e8f0;
        }
        
        .status-badge {
            display: inline-block;
            padding: 8px 16px;
            border-radius: 4px;
            font-size: 14px;
            font-weight: 600;
            text-transform: capitalize;
            margin-bottom: 20px;
            background-color: #e53e3e;
            color: white;
        }
        
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
                border-radius: 0;
            }
            
            .email-body, .email-footer {
                padding: 20px 15px !important;
            }
        }
    </style>
</head>
<body style="margin: 0; padding: 0; font-family: 'Nunito', Arial, sans-serif; background-color: #f4f4f4;">
    <div class="email-container">
        <div class="email-header">
            <img src="{{ $message->embed(public_path('assets/images/fie.jpg')) }}" alt="FIE Logo" class="email-logo">
            <div style="color: #ffffff; font-size: 14px; margin-top: 10px;">Service de Gestion des Plaintes</div>
        </div>
        
        <div class="email-body">
            <h1>Plainte déclarée irrecevable</h1>
            
            <p>Bonjour {{ $plainte->plaignant->nom ?? 'Madame, Monsieur' }},</p>
            
            <p>Nous vous informons que votre plainte n°{{ $plainte->numero }} a été examinée et déclarée irrecevable pour les raisons suivantes :</p>
            
            <div class="card" style="background-color: #fff5f5; border-color: #fed7d7;">
                <p style="color: #e53e3e; margin: 0; font-style: italic;">
                    {{ $plainte->commentaire_decision ?? 'Aucun commentaire fourni.' }}
                </p>
            </div>
            

            <div class="card">
                <h3 class="card-title">Détails de la plainte</h3>
                <table style="width: 100%; border-collapse: collapse;">
                    <tr>
                        <td style="padding: 8px 0; border-bottom: 1px solid #edf2f7; width: 40%; color: #718096; font-weight: 600;">Numéro de plainte :</td>
                        <td style="padding: 8px 0; border-bottom: 1px solid #edf2f7; color: #2d3748; font-weight: 600;">{{ $plainte->numero }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; border-bottom: 1px solid #edf2f7; color: #718096; font-weight: 600;">Date de dépôt :</td>
                        <td style="padding: 8px 0; border-bottom: 1px solid #edf2f7; color: #2d3748;">{{ $plainte->created_at->format('d/m/Y à H:i') }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; color: #718096; font-weight: 600;">Objet :</td>
                        <td style="padding: 8px 0; color: #2d3748;">{{ $plainte->objet }}</td>
                    </tr>
                </table>
            </div>
            
            <div class="card" style="background-color: #f0f9ff; border-color: #bae6fd;">
                <h4 style="color: #0369a1; margin: 0 0 10px 0; font-size: 16px; font-weight: 600;">Pour plus d'informations :</h4>
                <p style="margin: 0; color: #4a5568;">
                    Si vous avez des questions concernant cette décision, n'hésitez pas à nous contacter à l'adresse suivante : 
                    <a href="mailto:plaintes@fie.bf" style="color: #3182ce; text-decoration: none;">plaintes@fie.bf</a>
                </p>
            </div>
            
            <p style="margin: 25px 0 15px 0; color: #4a5568;">
                Nous vous remercions de votre compréhension,<br>
                <strong>L'équipe du Service des Plaintes FIE</strong>
            </p>
        </div>
        
        <div class="email-footer">
            <p style="margin: 0 0 10px 0;">
                <a href="{{ config('app.url') }}" style="color: #4a5568; text-decoration: none; font-weight: 600;">www.fie.bf</a>
                <span style="margin: 0 10px;">|</span>
                <a href="mailto:plaintes@fie.bf" style="color: #4a5568; text-decoration: none;">plaintes@fie.bf</a>
            </p>
            <p style="margin: 0 0 5px 0; font-size: 12px;">
                © {{ date('Y') }} FIE - Tous droits réservés
            </p>
            <p style="margin: 0; font-size: 11px; color: #a0aec0;">
                Ceci est un message automatique, merci de ne pas y répondre.
            </p>
        </div>
    </div>
</body>
</html>
