@extends('layouts.app')

@section('title', 'Tableau de bord')

@push('styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/apexcharts@3.35.0/dist/apexcharts.min.css">
<style>
    /* .card-stat {
        border-left: 4px solid;
        transition: transform 0.3s;
    } */
    .card-stat:hover {
        transform: translateY(-5px);
    }
    .stat-icon {
        font-size: 2.5rem;
        opacity: 0.3;
        position: absolute;
        right: 1.5rem;
        top: 1.5rem;
    }
    .activity-item {
        position: relative;
        padding-left: 2rem;
        border-left: 2px solid #e9ecef;
        margin-bottom: 1.5rem;
    }
    .activity-item:last-child {
        margin-bottom: 0;
    }
    .activity-item::before {
        content: '';
        position: absolute;
        left: -7px;
        top: 0;
        width: 12px;
        height: 12px;
        border-radius: 50%;
        background: #fff;
        border: 2px solid;
    }
    .fa-2x {
        font-size: 3rem;
    }
    .valeur {
        font-size: 5rem;
        margin: 0;
        padding: 0;
        line-height: 1;
        font-weight: bold;
        color: #808080;
    }
</style>
@endpush

@section('content')
<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="page-header mb-4">
        <h1 class="h3 mb-0">Tableau de bord</h1>
        <p class="text-muted">Aperçu des activités et statistiques</p>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <!-- Plaintes Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary card-stat py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total des plaintes</div>
                            <div class="valeur">{{ number_format($stats['total_plaintes']) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-exclamation-octagon fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer bg-transparent py-2">
                    <a href="{{ route('plaintes.index') }}" class="small text-primary font-weight-bold">
                        Voir les détails <i class="bi bi-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Plaintes en attente Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning card-stat py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Plaintes en attente</div>
                            <div class="valeur">{{ $stats['plaintes_en_attente'] }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer bg-transparent py-2">
                    <a href="{{ route('plaintes.index', ['statut' => 'en_attente']) }}" class="small text-warning font-weight-bold">
                        Voir les plaintes <i class="bi bi-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Financements Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success card-stat py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Demandes de financement</div>
                            <div class="valeur">{{ $stats['total_financements'] }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-currency-dollar fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer bg-transparent py-2">
                    <a href="{{ route('financements.index') }}" class="small text-success font-weight-bold">
                        Voir les demandes <i class="bi bi-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Financements en attente Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info card-stat py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Financements en attente</div>
                            <div class="valeur">{{ $stats['financements_en_attente'] }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer bg-transparent py-2">
                    <a href="{{ route('financements.index', ['statut' => 'en_attente']) }}" class="small text-info font-weight-bold">
                        Voir les demandes <i class="bi bi-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Plaintes par région -->
        <div class="col-lg-8 mb-4">
            <div class="card shadow-sm h-100">
                <div class="card-header bg-white">
                    <h6 class="m-0 font-weight-bold text-primary">Plaintes par région</h6>
                </div>
                <div class="card-body">
                    <div id="regionChart"></div>
                </div>
            </div>
        </div>

        <!-- Activités récentes -->
        <div class="col-lg-4 mb-4">
            <div class="card shadow-sm h-100">
                <div class="card-header bg-white d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-primary">Activités récentes</h6>
                    <a href="{{ route('activity-logs.index') }}" class="small">Voir tout</a>
                </div>
                <div class="card-body">
                    @if($recentActivities->count() > 0)
                        @foreach($recentActivities as $activity)
                        <div class="activity-item" style="border-left-color: var(--bs-{{ $activity['color'] }});">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <h6 class="mb-1">{{ $activity['titre'] }}</h6>
                                    <p class="small text-muted mb-1">
                                        <i class="bi bi-user me-1"></i> {{ $activity['user'] }}
                                    </p>
                                    <span class="badge bg-{{ $activity['color'] }} bg-opacity-10 text-white">
                                        {{ ucfirst($activity['statut']) }}
                                    </span>
                                </div>
                                <small class="text-muted">{{ $activity['date']->diffForHumans() }}</small>
                            </div>
                        </div>
                        @endforeach
                    @else
                        <div class="text-center py-4">
                            <i class="bi bi-inbox fa-3x text-muted mb-3"></i>
                            <p class="text-muted">Aucune activité récente</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <!-- Plaintes par région -->
        <div class="col-lg-8 mb-4">
            <div class="card shadow-sm h-100">
                <div class="card-header bg-white">
                    <h6 class="m-0 font-weight-bold text-primary">Plaintes par sensibilité</h6>
                </div>
                <div class="card-body">
                    <div id="sensibiliteChart"></div>
                </div>
            </div>
        </div>
        <div class="col-lg-4 mb-4">
            <div class="card shadow-sm h-100">
                <div class="card-header bg-white">
                    <h6 class="m-0 font-weight-bold text-primary">Sensibilité</h6>
                </div>
                <div class="card-body">
                    <div id="sensibiliteDonutChart"></div>
                </div>
            </div>
        </div>

    </div>
    <div class="row">
        <!-- Plaintes par mois -->
        <div class="col-lg-8 mb-4">
            <div class="card shadow-sm h-100">
                <div class="card-header bg-white">
                    <h6 class="m-0 font-weight-bold text-primary">Plaintes par mois</h6>
                </div>
                <div class="card-body">
                    <div id="moisChart"></div>
                </div>
            </div>
        </div>

    </div>
    <div class="row">
        <!-- Financements par mois -->
        <div class="col-lg-8 mb-4">
            <div class="card shadow-sm h-100">
                <div class="card-header bg-white">
                    <h6 class="m-0 font-weight-bold text-primary">Financements par mois</h6>
                </div>
                <div class="card-body">
                    <div id="financementMoisChart"></div>
                </div>
            </div>
        </div>

    </div>

</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/apexcharts@3.35.0/dist/apexcharts.min.js"></script>
<script>
    $(document).ready(function() {
        // // Region Chart
        // var regionData = @json($plaintesByRegion->pluck('total'));
        // var regionLabels = @json($plaintesByRegion->pluck('region'));
        var sensibiliteData = @json($plaintesBySensibilite);
        var sensibles = sensibiliteData.sensible;
        var nonSensibles = sensibiliteData.non_sensible;
        var totauxSensibilite = sensibiliteData.total;

        var moisData = @json($plaintesByMois->pluck('total'));
        var moisLabels = @json($plaintesByMois->pluck('mois'));
        var financementMoisData = @json($financementsByMois->pluck('total'));
        var financementMoisLabels = @json($financementsByMois->pluck('mois'));
        //Sensibilité Chart
        var optionsSensibilite = {
            series: [{
                name: 'Plaintes par sensibilité',
                data: Object.values(sensibiliteData),
            }],
            chart: {
                type: 'bar',
                height: 350,
                toolbar: {
                    show: true
                }
            },
            plotOptions: {
                bar: {
                    borderRadius: 4,
                    horizontal: true,
                    distributed: true,
                    barHeight: '60%',
                }
            },
            dataLabels: {
                enabled: false,
                formatter: function(val) {
                    return val;
                },
                style: {
                    fontSize: '12px',
                    colors: ['#fff']
                }
            },
            xaxis: {
                categories: ['Total','Sensible', 'Non sensible'],
                title: {
                    text: 'Nombre de plaintes'
                }
            },
            yaxis: {
                title: {
                    text: 'Niveau de sensibilité'
                }
            },
            colors: ['#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b', '#6c757d'],
            tooltip: {
                y: {
                    formatter: function (val) {
                        return val + " plaintes";
                    }
                }
            }
        };
        var optionsSensibiliteDonut = {
            series: [sensibles/totauxSensibilite, nonSensibles/totauxSensibilite],
            labels: ['Sensible', 'Non sensible'],
            chart: {
                type: 'donut',
                height: 350,
                toolbar: {
                    show: true
                },
            },
            plotOptions: {
                donut: {
                    labels: {
                        show: true,
                        name: {
                            show: true,
                            formatter: function(val) {
                                return val;
                            }
                        },
                        value: {
                            show: true,
                            formatter: function(val) {
                                return val + " plaintes";
                            }
                        }
                    }
                }
            }
        };
        var optionsMois = {
            series: [{
                name: 'Plaintes par mois',
                data: Object.values(moisData),
            }],
            chart: {
                type: 'bar',
                height: 350,
                toolbar: {
                    show: true
                }
            },
            plotOptions: {
                bar: {
                    borderRadius: 4,
                    horizontal: false,
                    distributed: true,
                    barHeight: '100%',
                }
            },
            dataLabels: {
                enabled: true,
                formatter: function(val) {
                    //get the month name from the month number
                    var monthNames = ['Janvier', 'Fevrier', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Aout', 'Septembre', 'Octobre', 'Novembre', 'Decembre'];
                    var month = monthNames[val];
                    return month;
                },
                style: {
                    fontSize: '12px',
                    colors: ['#fff']
                }
            },
            legend: {
                show: false,
                position: 'bottom',
                horizontalAlign: 'center',
                offsetX: 40,
                formatter: function(val) {
                    //get the month name from the month number
                    var monthNames = ['Janvier', 'Fevrier', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Aout', 'Septembre', 'Octobre', 'Novembre', 'Decembre'];
                    var month = monthNames[val-1];
                    return month;
                },
            },
            xaxis: {
                categories: moisLabels,
                title: {
                    text: 'Nombre de plaintes'
                },
                labels: {
                    formatter: function(val) {
                        //get the month name from the month number
                        var monthNames = ['Janvier', 'Fevrier', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Aout', 'Septembre', 'Octobre', 'Novembre', 'Decembre'];
                        var month = monthNames[val-1];
                        return month;
                    },
                },
            },
            yaxis: {
                title: {
                    text: 'Mois'
                }
            },
            colors: ['#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b', '#6c757d'],
            tooltip: {
                y: {
                    formatter: function (val) {
                        return val + " plaintes";
                    }
                }
            }
        };
        var optionsFinancementMois = {
            series: [{
                name: 'Financements par mois',
                data: Object.values(financementMoisData),
            }],
            chart: {
                type: 'bar',
                height: 350,
                toolbar: {
                    show: true
                }
            },
            legend: {
                show: false,
                position: 'bottom',
                horizontalAlign: 'center',
                offsetX: 40,
                formatter: function(val) {
                    //get the month name from the month number
                    var monthNames = ['Janvier', 'Fevrier', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Aout', 'Septembre', 'Octobre', 'Novembre', 'Decembre'];
                    var month = monthNames[val-1];
                    return month;
                },
            },
            plotOptions: {
                bar: {
                    borderRadius: 4,
                    horizontal: false,
                    distributed: true,
                    barHeight: '100%',
                }
            },
            dataLabels: {
                enabled: true,
                formatter: function(val) {
                    //get the month name from the month number
                    var monthNames = ['Janvier', 'Fevrier', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Aout', 'Septembre', 'Octobre', 'Novembre', 'Decembre'];
                    var month = monthNames[val-1];
                    return month;
                },
                style: {
                    fontSize: '12px',
                    colors: ['#fff']
                }
            },
            xaxis: {
                categories: moisLabels,
                title: {
                    text: 'Nombre de demandes de financements'
                },
                labels: {
                    formatter: function(val) {
                        //get the month name from the month number
                        var monthNames = ['Janvier', 'Fevrier', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Aout', 'Septembre', 'Octobre', 'Novembre', 'Decembre'];
                        var month = monthNames[val-1];
                        return month;
                    },
                },
            },
            yaxis: {
                title: {
                    text: 'Mois'
                }
            },
            colors: ['#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b', '#6c757d'],
            tooltip: {
                y: {
                    formatter: function (val) {
                        return val + " demandes de financements";
                    }
                }
            }
        };

        // var chart = new ApexCharts(document.querySelector("#regionChart"), options);
        var chart2 = new ApexCharts(document.getElementById("sensibiliteChart"), optionsSensibilite);
        var chart3 = new ApexCharts(document.getElementById("moisChart"), optionsMois);
        var chart4 = new ApexCharts(document.getElementById("financementMoisChart"), optionsFinancementMois);
        var chart5 = new ApexCharts(document.getElementById("sensibiliteDonutChart"), optionsSensibiliteDonut);
        // chart.render();
        chart2.render();
        chart3.render();
        chart4.render();
        chart5.render();
    });
</script>
@endpush