@extends('layouts.app')

@section('heading')
<div class="page-heading">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="{{ route('admin.dashboard') }}">Tableau de bord</a>
            </li>
            <li class="breadcrumb-item">
                <a href="{{ route('roles.index') }}">Rôles</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">{{ $role->name }}</li>
        </ol>
    </nav>
    <h3>Détails du rôle
        <div class="float-end">
            @can('role-edit')
            <a href="{{ route('roles.edit', $role) }}" class="btn btn-warning">
                <i class="bi bi-pencil"></i> Modifier
            </a>
            @endcan
            @can('role-delete')
            @if($role->name !== 'admin')
            <form action="{{ route('roles.destroy', $role) }}" method="POST" class="d-inline">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger" onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce rôle ?')">
                    <i class="bi bi-trash"></i> Supprimer
                </button>
            </form>
            @endif
            @endcan
            <a href="{{ route('roles.index') }}" class="btn btn-secondary">
                <i class="bi bi-arrow-left"></i> Retour
            </a>
        </div>
    </h3>
</div>
@endsection

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <!-- Informations du rôle -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header bg-light">
                        <h6 class="mb-0">
                            <i class="bi bi-info-circle"></i> Informations du rôle
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Nom du rôle</label>
                            <p class="form-control-plaintext">{{ $role->name }}</p>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Description</label>
                            <p class="form-control-plaintext">{{ $role->description ?? 'Aucune description' }}</p>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Date de création</label>
                            <p class="form-control-plaintext">{{ $role->created_at->format('d/m/Y H:i') }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Permissions du rôle -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header bg-light">
                        <h6 class="mb-0">
                            <i class="bi bi-shield-lock"></i> Permissions attribuées
                            <span class="badge bg-primary float-end">{{ $role->permissions->count() }}</span>
                        </h6>
                    </div>
                    <div class="card-body">
                        @php
                            $groupedPermissions = $role->permissions->groupBy(function ($permission) {
                                return explode('-', $permission->name)[0];
                            });
                        @endphp

                        @if($groupedPermissions->count() > 0)
                            @foreach($groupedPermissions as $group => $permissions)
                            <div class="mb-3">
                                <h6 class="fw-bold">
                                    <i class="bi bi-{{ $group == 'user' ? 'people' : ($group == 'role' ? 'person-badge' : 'key') }}"></i>
                                    {{ ucfirst($group) }}
                                </h6>
                                <div class="ms-3">
                                    @foreach($permissions as $permission)
                                    <span class="badge bg-success mb-1">
                                        {{ ucfirst(str_replace('-', ' ', $permission->name)) }}
                                    </span>
                                    @endforeach
                                </div>
                            </div>
                            @endforeach
                        @else
                            <div class="alert alert-info mb-0">
                                Aucune permission attribuée à ce rôle.
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

