{{-- resources/views/admin/roles/index.blade.php --}}
@extends('layouts.app')

@section('title', 'Gestion des Rôles')

@section('heading')
<div class="page-heading">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="{{ route('admin.dashboard') }}">Tableau de bord</a>
            </li>
            <li class="breadcrumb-item">
                <a href="{{ route('roles.index') }}">Rôles</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Créer</li>
        </ol>
    </nav>
    <h3>Créer un nouveau rôle
        <a href="{{ route('roles.index') }}" class="btn btn-secondary float-end">
                        <i class="bi bi-arrow-left"></i> Retour
                    </a>

    </h3>
</div>
@endsection
@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Liste des Rôles</h3>
                    {{-- @can('role-create') --}}
                    <a href="{{ route('roles.create') }}" class="btn btn-primary">
                        <i class="bi bi-plus"></i> Nouveau Rôle
                    </a>
                    {{-- @endcan --}}
                </div>

                <div class="card-body">
                    <!-- Filtre de recherche -->
                    <form method="GET" action="{{ route('roles.index') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-6">
                                <input type="text" name="search" class="form-control" 
                                       placeholder="Rechercher un rôle..." 
                                       value="{{ request('search') }}">
                            </div>
                            <div class="col-md-6">
                                <button type="submit" class="btn btn-outline-primary">
                                    <i class="bi bi-search"></i> Rechercher
                                </button>
                                <a href="{{ route('roles.index') }}" class="btn btn-outline-secondary ml-2">
                                    <i class="bi bi-x-lg"></i> Réinitialiser
                                </a>
                            </div>
                        </div>
                    </form>

                    <!-- Table des rôles -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th width="5%">ID</th>
                                    <th>Nom du rôle</th>
                                    <th>Permissions</th>
                                    <th width="12%">Utilisateurs</th>
                                    <th width="15%">Date de création</th>
                                    <th width="15%">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($roles as $role)
                                <tr>
                                    <td>{{ $role->id }}</td>
                                    <td>
                                        <strong>{{ ucfirst($role->name) }}</strong>
                                        @if($role->name === 'admin')
                                        <span class="badge bg-danger ml-1">Super Admin</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($role->permissions->count() > 0)
                                        <div class="d-flex flex-wrap">
                                            @foreach($role->permissions->take(3) as $permission)
                                            <span class="badge bg-info mx-1 mb-1">
                                                {{ $permission->name }}
                                            </span>
                                            @endforeach
                                            @if($role->permissions->count() > 3)
                                            <span class="badge bg-secondary">
                                                +{{ $role->permissions->count() - 3 }} autres
                                            </span>
                                            @endif
                                        </div>
                                        @else
                                        <span class="text-muted">Aucune permission</span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge bg-info">
                                            {{ $role->users()->count() }} 
                                            utilisateur{{ $role->users()->count() > 1 ? 's' : '' }}
                                        </span>
                                    </td>
                                    <td>{{ $role->created_at->format('d/m/Y H:i') }}</td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="{{ route('roles.show', $role) }}" 
                                               class="btn btn-info" title="Voir">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            
                                            @can('role-edit')
                                            <a href="{{ route('roles.edit', $role) }}" 
                                               class="btn btn-warning" title="Modifier">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            @endcan
                                            
                                            @can('role-delete')
                                            @if($role->name !== 'admin')
                                            <form method="POST" 
                                                  action="{{ route('roles.destroy', $role) }}" 
                                                  style="display: inline-block;"
                                                  onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer ce rôle ?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger" title="Supprimer">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                            @endif
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">
                                        <em>Aucun rôle trouvé.</em>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div>
                            Affichage de {{ $roles->firstItem() ?? 0 }} à {{ $roles->lastItem() ?? 0 }} 
                            sur {{ $roles->total() }} rôles
                        </div>
                        {{ $roles->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Statistiques rapides -->
<div class="row mt-4">
    <div class="col-md-4">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $roles->total() }}</h4>
                        <p class="mb-0">Rôles Total</p>
                    </div>
                    <div class="align-self-center">
                        <i class="bi bi-users-cog fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ \Spatie\Permission\Models\Permission::count() }}</h4>
                        <p class="mb-0">Permissions Total</p>
                    </div>
                    <div class="align-self-center">
                        <i class="bi bi-key fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ \App\Models\User::whereHas('roles')->count() }}</h4>
                        <p class="mb-0">Utilisateurs avec rôles</p>
                    </div>
                    <div class="align-self-center">
                        <i class="bi bi-user-check fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection