<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('financements', function (Blueprint $table) {
            $table->id();
            $table->string('reference')->unique();
            $table->string('nom_structure');
            $table->string('statut_juridique');
            $table->text('adresse');
            $table->string('telephone');
            $table->string('email');
            $table->string('numero_ifu');
            $table->string('numero_rccm');
            $table->string('region');
            $table->string('commune');
            $table->string('personne_habilitee');
            $table->string('intitule_activite');
            $table->text('resume_activite');
            $table->string('periode_mise_en_oeuvre');
            $table->string('organisations_partenaires');
            $table->decimal('cout_total', 15, 2);
            $table->decimal('montant_sollicite', 15, 2);
            $table->string('resultat_1');
            $table->string('resultat_2')->nullable();
            $table->string('resultat_3')->nullable();
            $table->string('resultat_4')->nullable();
            $table->string('resultat_5')->nullable();
            $table->string('resultat_6')->nullable();
            $table->json('guichet');
            $table->string('cible_1');
            $table->string('cible_2')->nullable();
            $table->string('cible_3')->nullable();
            $table->string('cible_4')->nullable();
            $table->string('contribution_visibilite');
            $table->string('statut')->nullable();
            $table->string('commentaire')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('financements');
    }
};
