<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('investigations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('plainte_id')->constrained('plaintes');
            $table->foreignId('investigateur_id')->constrained('users');
            
            $table->text('description');
            $table->json('actions_menees'); // Entretiens, examens documents, inspections
            $table->json('parties_prenantes'); // Personnes interrogées
            $table->text('conclusions');
            $table->json('preuves_collectees')->nullable();
            
            $table->datetime('date_debut');
            $table->datetime('date_fin')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('investigations');
    }
};
