<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('plaintes', function (Blueprint $table) {
            $table->id();
            $table->string('numero')->unique(); // Numéro auto-généré
            $table->string('reference')->unique(); // Numéro auto-généré
            $table->foreignId('plaignant_id')->nullable()->constrained('plaignants');
            
            // Informations sur la plainte
            $table->string('objet');
            $table->text('description');
            $table->json('preuves')->nullable(); // Documents/fichiers joints
            
            // Canal de réception
            $table->enum('canal_reception', [
                'boite_plaintes', 'verbal', 'courrier_physique', 
                'email', 'telephone', 'sms', 'whatsapp', 'web'
            ])->default('web');
            
            // Catégorisation
            $table->enum('type_plainte', ['sociale', 'environnementale', 'genre']);
            $table->enum('niveau_sensibilite', ['sensible', 'non_sensible']);
            
            // Statuts et dates importantes
            $table->enum('statut', [
                'en_attente', 'en_examen', 'recevable', 'irrecevable', 
                'en_enquete', 'resolu', 'en_appel', 'clos', 'transfere_tribunal'
            ])->default('en_attente');
            
            $table->datetime('date_reception');
            $table->datetime('date_accuse_reception')->nullable();
            $table->datetime('date_resolution')->nullable();
            $table->datetime('date_cloture')->nullable();
            
            // Assignation et traitement
            $table->string('niveau_traitement')->default('village'); // village, commune, region, central
            $table->foreignId('assigned_to')->nullable()->constrained('users');
            $table->text('decision')->nullable();
            $table->json('mesures_correctives')->nullable();
            
            // Métadonnées
            $table->boolean('est_anonyme')->default(false);
            $table->boolean('est_lanceur_alerte')->default(false);
            $table->text('remarques')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('plaintes');
    }
};
