<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Plaignant extends Model
{
    use HasFactory;

    protected $fillable = [
        'nom', 'prenom', 'telephone', 'email', 'adresse', 
        'sexe', 'handicap', 'type'
    ];

    protected $casts = [
        'handicap' => 'boolean',
    ];

    public function plainte()
    {
        return $this->hasMany(Plainte::class);
    }

    public function getFullNameAttribute()
    {
        return trim($this->nom . ' ' . $this->prenom);
    }
}
