<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Media extends Model
{
    protected $table ="media";
    protected $fillable = [
        'nom',
        'chemin',
        'type',
        'taille',
        'statut',
    ];

    public function mediable(){
        return $this->morphTo();
    }

    public function getStatutBadgeAttribute(){
        $statuses = [
            'en_attente' => 'En attente',
            'en_cours' => 'En cours d\'examen',
            'approuve' => 'Approuvé',
            'rejete' => 'Rejeté',
            'complet' => 'Dossier complet',
            'incomplet' => 'Dossier incomplet',
        ];

        $color = [
            'en_attente' => 'bg-yellow-100 text-yellow-800',
            'en_cours' => 'bg-blue-100 text-blue-800',
            'approuve' => 'bg-green-100 text-green-800',
            'rejete' => 'bg-red-100 text-red-800',
            'complet' => 'bg-green-100 text-green-800',
            'incomplet' => 'bg-red-100 text-red-800',
        ];

        return '<span class="px-2 py-1 text-xs font-semibold rounded-full ' . ($color[$this->statut] ?? 'bg-gray-100 text-gray-800') . '">' . 
               ($statuses[$this->statut] ?? $this->statut) . 
               '</span>';
    }
}
