<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Investigation extends Model
{
    protected $table = 'investigations';

    protected $fillable = [
        'plainte_id', 'investigateur_id', 'date_debut', 'date_fin', 'rapport'
    ];
    protected $casts = [
        'date_debut' => 'datetime',
        'date_fin' => 'datetime',
    ];
    public function plainte()
    {
        return $this->belongsTo(Plainte::class);
    }
    public function investigator()
    {
        return $this->belongsTo(User::class, 'investigateur_id');
    }
    
}
