<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Financement extends Model
{


    protected $fillable = [
        'nom_structure',
        'statut_juridique',
        'adresse',
        'email',
        'telephone',
        'numero_ifu',
        'numero_rccm',
        'region',
        'commune',
        'personne_habilitee',
        'intitule_activite',
        'resume_activite',
        'periode_mise_en_oeuvre',
        'organisations_partenaires',
        'cout_total',
        'montant_sollicite',
        'resultat_1',
        'resultat_2',
        'resultat_3',
        'resultat_4',
        'resultat_5',
        'resultat_6',
        'guichet',
        'cible_1',
        'cible_2',
        'cible_3',
        'cible_4',
        'contribution_visibilite',
        'statut',
        'commentaire',

    ];

    protected $casts = [
        'cout_total' => 'decimal:2',
        'montant_sollicite' => 'decimal:2',
        'guichet' => 'json',
    ];
    
    protected $appends = ['status_badge', 'formatted_amount', 'formatted_total_amount', 'piece_jointes_list'];
    
    // Add this to handle the old file paths in case you need to access them

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($financement) {
            $financement->reference = 'FN-' . now()->format('Ymd') . '-' . strtoupper(Str::random(6));
        });
        static::deleting(function ($financement) {
            $financement->media()->delete();
        });
    }
    public function media(){
        return $this->morphMany(Media::class,'mediable');
    }

    public function getStatusBadgeAttribute()
    {
        $statuses = [
            'en_attente' => 'En attente',
            'en_cours' => 'En cours d\'examen',
            'approuve' => 'Approuvé',
            'rejete' => 'Rejeté',
            'complet' => 'Dossier complet',
            'incomplet' => 'Dossier incomplet',
        ];

        $color = [
            'en_attente' => 'bg-yellow-100 text-yellow-800',
            'en_cours' => 'bg-blue-100 text-blue-800',
            'approuve' => 'bg-green-100 text-green-800',
            'rejete' => 'bg-red-100 text-red-800',
            'complet' => 'bg-green-100 text-green-800',
            'incomplet' => 'bg-red-100 text-red-800',
        ];

        return '<span class="px-2 py-1 text-xs font-semibold rounded-full ' . ($color[$this->statut] ?? 'bg-gray-100 text-gray-800') . '">' . 
               ($statuses[$this->statut] ?? $this->statut) . 
               '</span>';
    }

    public function getFormattedAmountAttribute()
    {
        return number_format($this->montant_sollicite, 2, ',', ' ') . ' FCFA';
    }

    public function getFormattedTotalAmountAttribute()
    {
        return number_format($this->cout_total, 2, ',', ' ') . ' FCFA';
    }
    
    /**
     * Get the list of piece_jointes with their names and paths
     */
    public function getPieceJointesListAttribute()
    {
        if (empty($this->piece_jointes)) {
            return [];
        }
        
        return array_map(function($path) {
            return [
                'name' => basename($path),
                'path' => $path,
                'url' => asset('storage/' . $path)
            ];
        }, $this->piece_jointes);
    }
    
    /**
     * Get the URL for the document_projet file
     */
    public function getDocumentProjetUrlAttribute()
    {
        return $this->document_projet_path ? asset('storage/' . $this->document_projet_path) : null;
    }
}
