<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Communication extends Model
{
    use HasFactory;
    protected $fillable = [
        'plainte_id', 'sent_by', 'type', 'canal', 
        'message', 'date_envoi', 'recu_confirmation'
    ];
    protected $casts = [
        'date_envoi' => 'datetime',
        'recu_confirmation' => 'boolean',
    ];
    public function plainte()
    {
        return $this->belongsTo(Plainte::class);
    }
    public function sender()
    {
        return $this->belongsTo(User::class, 'sent_by');
    }
    

}