<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Appel extends Model
{
    protected $table = 'appels';
    
    protected $fillable = [
        'plainte_id', 'date_appel', 'motif_appel', 'statut', 'decision_appel', 'date_decision_appel'
    ];

    protected $casts = [
        'date_appel' => 'datetime',
        'date_decision_appel' => 'datetime',
    ];

    public function plainte()
    {
        return $this->belongsTo(Plainte::class);
    }
}
