<?php

namespace App\Mail;

use App\Models\Resolution;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ResolutionStatusUpdatedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $resolution;
    public $status;

    public function __construct(Resolution $resolution, string $status)
    {
        $this->resolution = $resolution;
        $this->status = $status;
    }

    public function build()
    {
        return $this->subject('Mise à jour de la proposition de résolution - ' . ucfirst($this->status))
                   ->view('emails.resolution-status-updated');
    }
}