<?php

namespace App\Mail;

use App\Models\Resolution;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ResolutionProposedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $resolution;

    public function __construct(Resolution $resolution)
    {
        $this->resolution = $resolution;
    }

    public function build()
    {
        return $this->subject('Nouvelle proposition de résolution - Plainte #' . $this->resolution->plainte->numero)
                   ->view('emails.resolution-proposed');
    }
}