<?php

namespace App\Mail;

use App\Models\Plainte;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PlainteIrrecevableMail extends Mailable
{
    use Queueable, SerializesModels;

    public $plainte;

    /**
     * Create a new message instance.
     *
     * @param Plainte $plainte
     * @return void
     */
    public function __construct(Plainte $plainte)
    {
        $this->plainte = $plainte;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject("Votre plainte n°{$this->plainte->numero} a été déclarée irrecevable")
                   ->view('emails.plainte-irrecevable');
    }
}
