<?php

namespace App\Mail;

use App\Models\Financement;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class FinancementStatusChangeMail extends Mailable
{
    use Queueable, SerializesModels;

    public $financement;
    public $statusMessage;

    /**
     * Create a new message instance.
     *
     * @param Financement $financement
     * @param string $statusMessage
     * @return void
     */
    public function __construct(Financement $financement, string $statusMessage = '')
    {
        $this->financement = $financement;
        $this->statusMessage = $statusMessage;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject("Statut de votre demande de financement {$this->financement->reference}")
                   ->view('emails.financement-status-change', [
                       'financement' => $this->financement,
                       'statusMessage' => $this->statusMessage
                   ]);
    }
}
