<?php

namespace App\Mail;

use App\Models\Financement;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class FinancementAccuseReceptionMail extends Mailable
{
    use Queueable, SerializesModels;

    public $financement;
    public $accuseMessage;

    /**
     * Create a new message instance.
     *
     * @param Financement $financement
     * @param string $accuseMessage
     * @return void
     */
    public function __construct(Financement $financement, string $accuseMessage = '')
    {
        $this->financement = $financement;
        $this->accuseMessage = $accuseMessage;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject("Accusé de réception - Demande de financement {$this->financement->reference}")
                   ->view('emails.financement-accuse-reception', [
                       'financement' => $this->financement,
                       'accuseMessage' => $this->accuseMessage
                   ]);
    }
}
