<?php

namespace App\Http\Controllers;

use App\Models\Plainte;
use App\Models\Investigation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class InvestigationController extends Controller
{
    public function create(Plainte $plainte)
    {
        return view('investigations.create', compact('plainte'));
    }

    public function store(Request $request, Plainte $plainte)
    {
        $validated = $request->validate([
            'description' => 'required|string',
            'actions_menees' => 'required|array',
            'parties_prenantes' => 'nullable|array',
            'conclusions' => 'required|string',
            'date_debut' => 'required|date',
            'date_fin' => 'nullable|date|after:date_debut',
        ]);

        $investigation = Investigation::create([
            'plainte_id' => $plainte->id,
            'investigateur_id' => Auth::id(),
            ...$validated
        ]);

        // Mettre à jour le statut de la plainte
        $plainte->update(['statut' => 'en_enquete']);

        return redirect()->route('plaintes.show', $plainte)
                        ->with('success', 'Enquête créée avec succès');
    }
}
