<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class init extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'db:init';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        
         // Nulling current database before dropping 
        config(["database.connections.pgsql.database" => null]);
        $db=env('DB_DATABASE');
        $this->info('Dropping existing database...');
        $query = "DROP DATABASE IF EXISTS $db  WITH (FORCE);";
        DB::statement($query);
        // Database creation query statement
        $this->info('Creating new database...');
        $query = "CREATE DATABASE $db WITH TEMPLATE = template0 ENCODING = 'UTF8'";
        DB::statement($query);
        //Re-switch my DB
        $this->info('Switching to new database...');
        config(["database.connections.pgsql.database" => "$db"]);
        //Apply new changes 
        $this->info('Applying changes...');
        DB::purge('pgsql');
        // All database schemas re-creation
        $this->info('Re-creating database schema...');
        $this->call('migrate:fresh');
        // Seed the database with initial data
        $this->info('Seeding database with initial data...');
        $this->call('db:seed');
        // Initialiser la base de données
        $this->info('Database initialized successfully.');
        return Command::SUCCESS;
       
    }
}
