<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class CheckComplaintDeadlines extends Command
{
    protected $signature = 'plaintes:check-deadlines';
    protected $description = 'Vérifier les délais de traitement des plaintes';

    public function handle()
    {
        $overdueComplaints = Plainte::whereIn('statut', ['recu', 'en_examen', 'en_enquete'])
                                    ->get()
                                    ->filter->isDelaiDepasse();

        $this->info("Vérification des délais...");
        $this->info("Plaintes en retard: " . $overdueComplaints->count());

        foreach ($overdueComplaints as $plainte) {
            // Notifier les responsables
            $this->notifyOverdueComplaint($plainte);
            
            $this->line("Plainte {$plainte->numero} en retard de {$plainte->delai_traitement} jours");
        }

        return Command::SUCCESS;
    }

    private function notifyOverdueComplaint(Plainte $plainte)
    {
        // Envoyer notification aux managers
        $managers = User::where('role', 'manager')->get();
        
        foreach ($managers as $manager) {
            Mail::to($manager->email)->send(new OverdueComplaintMail($plainte));
        }
    }
}
