# Système de Gestion des Plaintes

<p align="center">
  <img src="https://laravel.com/img/logomark.min.svg" alt="Laravel" width="100">
  <img src="https://tailwindcss.com/favicons/favicon-32x32.png" alt="Tailwind CSS" width="32" style="margin: 0 20px;">
  <img src="https://vitejs.dev/logo.svg" alt="Vite" width="32">
</p>

<p align="center">
  <a href="#"><img src="https://img.shields.io/badge/Licence-MIT-blue.svg" alt="Licence: MIT"></a>
  <a href="https://laravel.com/"><img src="https://img.shields.io/badge/Laravel-12.x-red.svg" alt="Laravel 12.x"></a>
  <a href="https://php.net/"><img src="https://img.shields.io/badge/PHP-8.2+-777BB4.svg" alt="PHP 8.2+"></a>
  <a href="https://tailwindcss.com/"><img src="https://img.shields.io/badge/Tailwind_CSS-3.4.0-06B6D4.svg" alt="Tailwind CSS 3.4.0"></a>
</p>

## Table des matières

- [Aperçu](#-aperçu)
- [Fonctionnalités](#-fonctionnalités)
- [Prérequis](#-prérequis)
- [Installation](#-installation)
- [Configuration](#-configuration)
- [Utilisation](#-utilisation)
- [Points d'API](#-points-dapi)
- [Tests](#-tests)
- [Déploiement](#-déploiement)
- [Sécurité](#-sécurité)
- [Contribution](#-contribution)
- [Licence](#-licence)

## 📋 Aperçu

Le Système de Gestion des Plaintes est une solution complète de gestion des réclamations et des dossiers, développée avec Laravel 12. Il offre une plateforme robuste pour gérer les plaintes, les enquêtes et les résolutions, avec support multilingue et contrôle d'accès basé sur les rôles.

## ✨ Fonctionnalités

- **Gestion des Plaintes**
  - Formulaire public de dépôt de plainte
  - Suivi et mise à jour du statut des plaintes
  - Support des pièces jointes
  - Notifications en temps réel

- **Workflow d'Enquête**
  - Attribution des dossiers aux enquêteurs
  - Suivi de l'avancement des enquêtes
  - Journalisation des communications
  - Propositions de résolution

- **Gestion des Utilisateurs**
  - Contrôle d'accès basé sur les rôles (Admin, Enquêteur, Utilisateur)
  - Journalisation des activités utilisateur
  - Support multilingue (Français, Anglais, etc.)
  - Gestion des profils

- **Gestion des Demandes de Financement**
  - Formulaire de dépôt de demande en ligne
  - Suivi de l'état des demandes
  - Gestion des pièces justificatives
  - Workflow de validation
  - Notification des décisions
  - Historique des demandes
  - Export des données pour analyse

- **Rapports**
  - Tableaux de bord en temps réel
  - Rapports mensuels
  - Fonctionnalité d'export
  - Journaux d'audit

- **API**
  - Points d'API RESTful
  - Authentification JWT
  - Limitation du débit
  - Support CORS

## 🚀 Prérequis

- PHP 8.2 ou supérieur
- Composer
- Node.js 18+ et NPM
- MySQL 8.0+ ou MariaDB 10.4+
- Serveur web (Apache/Nginx)
- Redis (pour le cache et les files d'attente, optionnel mais recommandé)

## 🛠️ Installation

1. **Cloner le dépôt**
   ```bash
   git clone [url-du-dépôt] plaintes
   cd plaintes
   ```

2. **Installer les dépendances PHP**
   ```bash
   composer install
   ```

3. **Installer les dépendances JavaScript**
   ```bash
   npm install
   ```

4. **Copier le fichier d'environnement**
   ```bash
   cp .env.example .env
   ```

5. **Générer la clé d'application**
   ```bash
   php artisan key:generate
   ```

6. **Configurer la base de données**
   Mettez à jour le fichier `.env` avec vos identifiants de base de données :
   ```env
   DB_CONNECTION=mysql
   DB_HOST=127.0.0.1
   DB_PORT=3306
   DB_DATABASE=plaintes
   DB_USERNAME=root
   DB_PASSWORD=
   ```

7. **Exécuter les migrations et les seeders**
   ```bash
   php artisan migrate --seed
   ```

8. **Compiler les assets**
   ```bash
   npm run build
   ```

9. **Démarrer le serveur de développement**
   ```bash
   php artisan serve
   ```

10. **Accéder à l'application**
    Ouvrez votre navigateur et visitez : [http://localhost:8000](http://localhost:8000)

## ⚙️ Configuration

### Variables d'environnement

Variables principales à configurer :

```env
APP_NAME="Système de Gestion des Plaintes"
APP_ENV=local
APP_DEBUG=true
APP_URL=http://localhost:8000

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=plaintes
DB_USERNAME=root
DB_PASSWORD=

MAIL_MAILER=smtp
MAIL_HOST=mailhog
MAIL_PORT=1025
MAIL_USERNAME=null
MAIL_PASSWORD=null
MAIL_ENCRYPTION=null
MAIL_FROM_ADDRESS="contact@example.com"
MAIL_FROM_NAME="${APP_NAME}"
```

### Permissions des fichiers

Assurez-vous que les permissions sont correctement définies :

```bash
chmod -R 775 storage/
chmod -R 775 bootstrap/cache/
```

## 🚦 Utilisation

### Commandes disponibles

| Commande | Description |
|---------|-------------|
| `php artisan serve` | Démarrer le serveur de développement |
| `php artisan queue:work` | Traiter les tâches en file d'attente |
| `php artisan schedule:work` | Exécuter les tâches planifiées |
| `npm run dev` | Compiler les assets pour le développement |
| `npm run build` | Compiler les assets pour la production |

### Identifiants administrateur par défaut

Après l'initialisation :
- **Email :** admin@example.com
- **Mot de passe :** password

## 🌐 Points d'API

### Authentification

| Méthode | Point d'accès | Description |
|--------|--------------|-------------|
| POST   | /api/login | Connexion utilisateur |
| POST   | /api/register | Inscription utilisateur |
| POST   | /api/logout | Déconnexion utilisateur |
| GET    | /api/user | Récupérer l'utilisateur connecté |

### Plaintes

| Méthode | Point d'accès | Description |
|--------|--------------|-------------|
| GET    | /api/plaintes | Lister toutes les plaintes |
| POST   | /api/plaintes | Créer une nouvelle plainte |
| GET    | /api/plaintes/{id} | Obtenir les détails d'une plainte |
| PUT    | /api/plaintes/{id} | Mettre à jour une plainte |
| DELETE | /api/plaintes/{id} | Supprimer une plainte |

### Demandes de Financement

| Méthode | Point d'accès | Description |
|--------|--------------|-------------|
| GET    | /api/financements | Lister toutes les demandes |
| POST   | /api/financements | Soumettre une nouvelle demande |
| GET    | /api/financements/{id} | Voir les détails d'une demande |
| PUT    | /api/financements/{id} | Mettre à jour une demande |
| PATCH  | /api/financements/{id}/status | Mettre à jour le statut d'une demande |
| GET    | /api/financements/{reference}/suivi | Suivre l'état d'une demande |

## 🧪 Tests

Exécuter les tests PHPUnit :

```bash
php artisan test
```

Exécuter PHPStan pour l'analyse statique :

```bash
./vendor/bin/phpstan analyse
```

## 🚀 Déploiement

### Déploiement en production

1. **Optimiser la configuration**
   ```bash
   php artisan config:cache
   php artisan route:cache
   php artisan view:cache
   ```

2. **Exécuter les migrations**
   ```bash
   php artisan migrate --force
   ```

3. **Optimiser Composer**
   ```bash
   composer install --optimize-autoloader --no-dev
   ```

4. **Compiler les assets**
   ```bash
   npm run build
   ```

### Gestionnaires de file d'attente

Pour la production, configurez un gestionnaire de processus comme Supervisor pour maintenir le worker de file d'attente en cours d'exécution :

```ini
[program:plaintes-worker]
process_name=%(program_name)s_%(process_num)02d
command=php /chemin/vers/plaintes/artisan queue:work --sleep=3 --tries=3 --max-time=3600
autostart=true
autorestart=true
stopasgroup=true
killasgroup=true
user=www-data
numprocs=8
redirect_stderr=true
stdout_logfile=/chemin/vers/plaintes/storage/logs/worker.log
stopwaitsecs=3600
```

## 🔒 Sécurité

### Bonnes pratiques de sécurité

- Validation des entrées sur tous les formulaires
- Protection CSRF
- Protection XSS
- Prévention des injections SQL
- Limitation du débit
- Hachage sécurisé des mots de passe
- Application du protocole HTTPS
- En-têtes de sécurité

### Signaler des vulnérabilités

Si vous découvrez une vulnérabilité de sécurité, veuillez envoyer un email à securite@example.com. Toutes les vulnérabilités seront traitées dans les meilleurs délais.

## 🤝 Contribution

1. Forkez le dépôt
2. Créez votre branche de fonctionnalité (`git checkout -b fonctionnalite/ma-nouvelle-fonctionnalite`)
3. Committez vos modifications (`git commit -m 'Ajouter une nouvelle fonctionnalité'`)
4. Poussez vers la branche (`git push origin fonctionnalite/ma-nouvelle-fonctionnalite`)
5. Ouvrez une Pull Request

## 📄 Licence

Ce projet est sous licence MIT - voir le fichier [LICENCE](LICENCE) pour plus de détails.

## 🙏 Remerciements

- [Laravel](https://laravel.com)
- [Tailwind CSS](https://tailwindcss.com)
- [Vite](https://vitejs.dev)
- [Spatie Laravel Permission](https://github.com/spatie/laravel-permission)
- [Laravel Activity Log](https://github.com/spatie/laravel-activitylog)
